; Disassembly of the file "BASICDEM.BIN" {note: based on previous
; disassembly of the file "BallyBAS.BIN" aka Bally Basic (C)1978}
; Programmed and Commented by: Jay Fenton for Bally Manufacturing
;
; CPU Type: Z80 - for Bally Home Video Game / Home Library System
;
; Created with dZ80 1.50 and a whole lot of hand editing/copying!
; Re-assembles 100% correctly with: zmac -i -m BASICDEM.ASM
;
; Dis-assembled and pasted-up by: Richard C. Degler, From Scratch
; Beginning on or about Monday, 21 of April 2008 at 07:42 PM, and
; BASICDEM.ASM started Sunday, 28 of February 2010 at 01:30 PM
;
; Renamed some labels and added a very few comments in Mixed Case
;

; Source of Jay Fenton's comments is "astrobas.asm" by Adam Trionfo
; retyped from a wrapped-around paper listing with page headings of:
;
; TDL Z80 CP/M DISC ASSEMBLER VERSION 2.21 [overwritten by Page #]
; .MAIN. -
;
; Note: The only text in "bally_basic_souce_pages_01-32.pdf" was:
;
; > Bally BASIC Interpreter
; >
; >  July 1978 Bally Mfg.
; >  December 1980 Revised
; >
; > Written by Jay Fenton
;
; and:
;
; > This page left blank for double-sided printing purposes.
;

; Part Two - Assembly Code for the file "BallyBASIC (listing).ASM"
; Programmed by: Jay Fenton for Bally Manufacturing [see Part One]
;
; Reverse-source code found by Brett Bilbrey - "Bally Basic (1979)"
; Loose Leaf paper listing Scanned and saved as PDF by Adam Trionfo
; moved to Bally Alley Yahoo! user group dated Friday, May 15, 2009
;
; Comments (ONLY) then retyped by: Richard C. Degler, From Scratch
; Beginning on Memorial Day Eve Sunday, 24 of May 2009 at 02:24 PM
;
; To match the style (and only where useful) these are marked by ;*
; Author Unknown, but no LC decenders listing had page headings of:
;
; CROMEMCO CDOS Z80 ASSEMBLER version 02.15                  PAGE 0001
; Bally Tiny Basic        8/25/79
;
; [without leading semi-colons used here] and a program identifier:
;
;                   0002 ;************************************************
;                   0003 ;*                                              *
;                   0004 ;*              Bally Tiny Basic                *
;                   0005 ;*                                              *
;                   0006 ;*                  8/25/79                     *
;                   0007 ;*                                              *
;                   0008 ;************************************************
;                   0009 ;
;
; [End of Header]
;

; Part Three - Bally Basic DEMO program listing resurfaced recently (included
; after END below), and discovering that it didn't use a standard BALLY BASIC
; added the Conditional Assembly labels below to generate these 2^3 binaries:
;
;  '--- if 1 = INROM (increases size by 4K program) else 0 = INRAM (SZ=1800)
;  | '--- if 1 = NOKEY (seems backwards, don't it?) else 0 = KEYBD (works)
;  | | '--- if 1 = TESTC (added GLED routine, broke 300 baud) else 0 = NORML
;  | | |
;  v v v  resulting assembly:
;  0 0 0  =  BALLYBAS.BIN of which this Source Code is based on originally
;  0 0 1  =  GLEDBBAS.BIN prototype with Graphic Line EDitor in Bally BASic
;  0 1 0  =  INRAM but NOKEY means no program and no way to enter one!
;  0 1 1  =  ditto!!
;  1 0 0  =  Basic Demo program can be LISTed but not changed (it crashes.)
;  1 0 1  =  " same as above with Graphic Line EDitor on but can't be used.
;  1 1 0  =  functions the same as BASICDEM.BIN since the keypad is off, and
;  1 1 1  =  BASICDEM.BIN as included in the BALLY.ZIP dump for emulators
;
; see BASIC DEMO Cartridge with chain attached at: http://tinyurl.com/ykuachj
;
  ; ###### Conditional Assembly control marked by ######'s
  ; ### Important note: for BASICDEM, set ALL three ONEs!
  ; ###                                              ###
INROM  EQU      1       ; also loads BASIC DEMO program
INRAM  EQU      1-INROM ; should have KEYBD turned on
  ; ###                                              ###
NOKEY  EQU      0       ; not useful unless program INROM
KEYBD  EQU      1-NOKEY ; else short-circuits to RUN:
  ; ###                                              ###
TESTC  EQU      0       ; not useful without KEYBD active
NORML  EQU      1-TESTC ; also should have KEYBD active
  ; ###                                              ###
  ; ### note: makes old BALLY BASIC with ALL three ZEROs!!
  ; ####################################################

; This page intentionally left blank for double-sided printing purposes
;

; Here then is:
;
; ***************************
; * BALLY BASIC INTERPRETER *    [Comments WERE for Astro Basic]
; *                         *    [so ignore changes to comments]
; * (C) JULY 1978 BALLY MFG *    [; * (C) DEC 1980 REVISED    *]
; *                         *
; * WRITTEN BY: JAY FENTON  *
; *                         *
; * PALO ALTO TINY BASIC BY *
; * LICHEN WANG             *
; *                         *
; ***************************
; TINY BASIC INTERPRETER  [with original 300 baud tape interface]
;

        NOLIST

        INCLUDE "HVGLIB.H"      ; HOME VIDEO GAME LIBRARY
;
; MACROS
TOKEN   MACRO   TINDX, TGOTO
        DB      TINDX
        DEFF    TGOTO
        ENDM

ITEM    MACRO   STRANG, JUMPTO  ; Quoted Character
        DB      'STRANG'
        DEFF    JUMPTO
        ENDM

DEFF    MACRO   WORDY          ;* Jump table entry
        DB      (WORDY >> 8) | $80
        DB      WORDY & $FF
        ENDM

TSTC    MACRO   CAT, DOG
        RST     $08
        DB      'CAT'          ;* Char. to check
        DB      (DOG - $)-1    ;* Jump bias if no match
        ENDM

TSTCC   MACRO   CAT1, DOG1
        RST     $08
        DB      CAT1           ;* Char. to check
        DB      (DOG1 - $)-1   ;* Jump bias if no match
        ENDM

;           Defines
DEADKEY EQU     $01
CR      EQU     $0D
RUBOUT  EQU     $1F
COMMA   EQU     $2C
EDKEY   EQU     $66
NLLN    EQU     $67
;
; EQUATES FOR RESTART INSTRUCTIONS
RSTEXP  EQU     $10             ; EXPR - Get EXPRession restart  ;* Evaluate expression
RSTOUT  EQU     $18             ; OUTC - OUT Char [became LDE - LoaD A, from (DE) in ab]
RSTIGN  EQU     $20             ; IGNBLK - IGNore BLanKs  ;* Get next non-blank from (DE)
RSTPAR  EQU     $28             ; PARN - expression in PAReNthesis  ;* Get value in ()
RSTFIN  EQU     $30             ; FINISH - Routine FINISH  ;* cr. or ; otherwise, WHAT?
;
BOTROM  EQU     FIRSTC          ; $2000
;
; Scratchpad area:
BOTSCR  EQU     $4E20           ; BOTtom of SCReen [from $4000 to $4E18+2*4 [same as ab]]
TAPINS  EQU     BOTSCR         ;* TAPe INSert pointer
TAPEXT  EQU     $4E21          ;* TAPe EXTract pointer
TAPBUF  EQU     $4E22           ; [48 bytes of TAPe input BUFfer]
TXTUNF  EQU     $4E52          ;* "End of Basic Pgm" address [plus 2 is a -1 ??]
VDMNLF  EQU     $4E54           ; VDM NEW LINE FLAG
KEYTMR  EQU     $4E55           ; KEYBOARD SCAN TIMER  ;* Key release timer (60 Hz)
MUZTMR  EQU     $4E56           ; MUSIC NOTE TIMER  ;* Time remaining on current note
NEWTMR  EQU     $4E57           ; NEW MUSIC TIMER VALUE  ;* Time for next note
MUZMO   EQU     $4E58           ; MASTER OSC FOR DICK  ;* Master sound divider value
MUZTON  EQU     $4E59           ; TONE VALUE  ;* Next note to output
SHARPF  EQU     $4E5A           ; SHARP-FLAT
EDFLG   EQU     $4E5B           ; line EDit FLaG {new for BASICDEM}, or
PIXVAL  EQU     EDFLG           ; PIXel VALue TO DRAW WITH
EDPTR   EQU     $4E5C           ; line EDit PoinTeR {also new}, or
MNMX    EQU     EDPTR           ; MiN - MaX DELTAS FOR VECTOR DRAW
INCRO   EQU     $4E5E           ; COORDINATE INCRements FOR VECTOR DRAW
NLLNLN  EQU     $4E60           ; AUTO LINE # STUFF
NLLNCT  EQU     $4E62
NLLNZS  EQU     $4E63           ; AUTO LINE NUMBER Zero Suppress FLAG
OLDLN   EQU     $4E64           ; PREVIOUS LINE # TYPED (used for GO+10)
ALTFON  EQU     $4E66           ; 7 byte ALTernate FONt descriptor
                               ;* Character Spec Table
; ??  EQU     $4E6C            ;* [+6 ??] Indexes VRBL storage area
KEYTRK  EQU     $4E6D           ; KEYpad debounce TRacKer  ;* Last calc. input
;
VARBGN  EQU     $4E6E           ; One-letter variables (two bytes each)
DEVVAR  EQU     $4EA2           ; Two-letter DEVICES VARIABLES thusly:
DEVCL0  EQU     DEVVAR          ; BC = Background Color 0 (default 7)
DEVCL1  EQU     $4EA4           ; FC = Foreground Color 1 (default 0)
DEVTEM  EQU     $4EA6           ; NT = TEMPO Note Timer (default 3)
VDMX    EQU     $4EA8           ; CX = VDM X COORDINATE (default -77)
VDMY    EQU     $4EAA           ; CY = VDM Y COORDINATE (default 40)
OLDXY   EQU     $4EAC           ; XY = PREVIOUS COORDINATES FROM VECTOR DRAW
REMAIN  EQU     $4EAE           ; RM = REMAINDER FROM LAST DIVIDE
;
BCDN1   EQU     $4EB0           ; 16 BCDigits for $ Calculator routine [+- 8.8]
BCDN2   EQU     $4EB9           ; second 16 BCDigits [each is 8 bytes plus sign]
;
CHMODE  EQU     $4EC2          ;* I/O flag 0=KBD in, VID out
                               ;*          1=TAP in, VID out
                               ;*          2=KBD in, TAP out
                               ;*          6=KBD in, TAP out
                               ;*                    (expanded)
CURRNT  EQU     $4EC3           ; CURReNT line
STKGOS  EQU     $4EC5           ; STacK for GOSub
STKINP  EQU     $4EC7           ; ??
VARNXT  EQU     STKINP         ;* "NEXT" VRBL address
LOPVAR  EQU     $4EC9           ; FOR VARiable  ;* "FOR" VRBL address
LOPINC  EQU     $4ECB           ; FOR STEP  ;* "STEP" VRBL address
LOPLMT  EQU     $4ECD           ; FOR TO  ;* "TO" VRBL address
LOPLN   EQU     $4ECF           ; LOoP Line Number  ;* Line # of current FOR loop
LOPPT   EQU     $4ED1           ; 3 bytes LOoP PoinTer  ;* Current FOR line text pointer
;
BUFFER  EQU     $4ED4           ; line input BUFFER  ;* Keyboard input buffer
BUFEND  EQU     $4F3C           ; BUFfer END (104 Characters)  ;*  to $4FC3 [TYPO ??]
; ?? unused block of 32 bytes ??
STKLMT  EQU     $4F5C           ; STacK LiMiT (147 bytes available)
TOPSCR  EQU     RANSHT          ; $4FEF used for Top of Stack
STACKP  EQU     TOPSCR          ; Initialized STACK Pointer
;
if INROM ; ### conditional assembly ### {DEMO program stored in ROM}
TXT     EQU     $3000           ; [was TEXT] Text Array Area [NOT flagged as negative]
DFTLMT  EQU     $3FFF           ; [Last non-interlaced address for SZ = $4000 bytes]
else ; INRAM ####### conditional ###### else...
BOTRAM  EQU     $A000           ; [Denotes $4000 but shared with screen image]
TXT     EQU     BOTRAM          ; [was TEXT] Text Array Area [flagged as negative ??]
DFTLMT  EQU     TXT + $070C     ; [Last interlaced address is $A70C]
; [use final two routines to read/write bit-shared data from screen+$6000 ?? [counts??]]
endif ; ##### end conditional #########
;
        LIST

        ORG     BOTROM

; L2000:
        JP      BEGIN           ; ** AUTOSTART CASSETTE **

PIXTBL: DB      $80            ;* Masks for picture data (PX)
        DB      $20
        DB      $08
        DB      $02

; TRANSFER VECTORS TO RESTART ROUTINES
        JP      TSTCH           ; * RST $08

        JP      EXPR            ; * RST RSTEXP  ;* Evaluate expression

        JP      OUTC            ; * RST RSTOUT  [became LDE  ; * RST RSTLDE in ab ??]

        JP      IGNBLK          ; * RST RSTIGN  ;* Get next non-blank from (DE)

        JP      PARN            ; * RST RSTPAR  ;* Get value of () or storage adrs

        POP     AF              ; * RST RSTFIN  ;* cr. or ; otherwise, WHAT?
        JP      FINISH

; external Transfer Vector to get a character from cassette tape into A
L201A:  JP      CHKIO           ; use TV=CALL 8218  from Basic Program

; INITIAL VALUES FOR PARAMETER VECTOR  ;* Following is moved to DEVVAR at $4EA2
INIDEV:
        DW      $0007           ; BACKGROUND COLOR  ;* BC preset-White
        DW      $0000           ; FOREGROUND COLOR  ;* FC preset-Black
        DW      $0003           ; MUSIC TEMPO  ;* NT preset
INIVDM:
        DW      $FFB3           ; (-77) VDM X COORDINATE  ;* CX preset
        DW      $0028           ; (40) VDM Y COORDINATE  ;* CY preset
        DW      $0000           ; OLDXY COORDINATE  ;* XY preset

; Text Strings
BBASIC: DB      'BALLY BASIC',CR

WHAT:   DB      'WHAT?',CR

HOW:    DB      'HOW?',CR

SORRY:  DB      'SORRY',CR

; TABLE GIVING JUMP TO ADDRESS FOR COMMANDS
TOKJT:
        DW      LISTCOM         ; $68 - 'LIST' COMmand routine
        DW      CLRSCR          ; $69 - 'CLEAR'
        DW      RUN             ; $6A - 'RUN'
        DW      NEXT            ; $6B - 'NEXT'
        DW      LINEDR          ; $6C - 'LINE'
        DW      IFF             ; $6D - 'IF'
        DW      GOTO            ; $6E - 'GOTO'
        DW      GOSUB           ; $6F - 'GOSUB'
        DW      RETURN          ; $70 - 'RETURN'
        DW      BOXDRW          ; $71 - 'BOX'
        DW      FOR             ; $72 - 'FOR'
        DW      INPUT           ; $73 - 'INPUT'
        DW      PRINT           ; $74 - 'PRINT'

; INTERRUPT VECTOR ITEMS
        DW      LPINT           ; (ITAB & $FFF0) Light Pen INTerrupt vector

ITAB:   DW      TBIINT          ; Tiny Basic Interpreter INTerrupt vector

; TABLE GIVING ASCII CHARS FOR TOKENS with last character marked negative
TOKTXT:
        DB      'LIS'
        DB      'T' + $80       ; ($68) "LIST" Text
        DB      'CLEA'
        DB      'R' + $80       ; ($69) "CLEAR"
        DB      'RU'
        DB      'N' + $80       ; ($6A) "RUN"
        DB      'NEX'
        DB      'T' + $80       ; ($6B) "NEXT"
        DB      'LIN'
        DB      'E' + $80       ; ($6C) "LINE"
        DB      'I'
        DB      'F' + $80       ; ($6D) "IF"
        DB      'GOT'
        DB      'O' + $80       ; ($6E) "GOTO"
        DB      'GOSU'
        DB      'B' + $80       ; ($6F) "GOSUB"
        DB      'RETUR'
        DB      'N' + $80       ; ($70) "RETURN"
        DB      'BO'
        DB      'X' + $80       ; ($71) "BOX"
        DB      'FO'
        DB      'R' + $80       ; ($72) "FOR"
        DB      'INPU'
        DB      'T' + $80       ; ($73) "INPUT"
        DB      'PRIN'
        DB      'T' + $80       ; ($74) "PRINT"
        DB      'STE'
        DB      'P' + $80       ; ($75) "STEP"
        DB      'RN'
        DB      'D' + $80       ; ($76) "RND"
        DB      'T'
        DB      'O' + $80       ; ($77) "TO"

; DEVICE VARIABLE TABLE  /* Special 2-letter variables
; THIS TABLE IS IN INVERSE ORDER OF APPEARENCE IN MEMORY
PARNUM  EQU     7
DEVLST:                         ; [has first character minus $40 for ?? why??]
        DB      'R' - '@'
        DB      'M'             ; "RM" = ReMainder from last divide
        DB      'X' - '@'
        DB      'Y'             ; "XY" = Location from last draw
        DB      'C' - '@'
        DB      'Y'             ; "CY" = Character print Y
        DB      'C' - '@'
        DB      'X'             ; "CX" = Character print X
        DB      'N' - '@'
        DB      'T'             ; "NT" = Note Tempo
        DB      'F' - '@'
        DB      'C'             ; "FC" = Foreground Color
        DB      'B' - '@'
        DB      'C'             ; "BC" = Background Color

; TINY BASIC INTERRUPT ROUTINE
;* NORMAL INTERRUPT PROCESSOR
;
TBIINT: PUSH    AF              ; SAVE REGISTERS
        PUSH    BC
        PUSH    DE
        PUSH    HL
; DEAL WITH KEYBOARD SCAN TIMER
        LD      HL,KEYTMR
        LD      A,(HL)         ;* Get key release timer
        AND     A
        JR      Z,TBIN1        ;* Jp if already zero
        DEC     (HL)            ; Count KEYTMR down to Zero
TBIN1:  INC     HL              ; Point to MUZTMR
; HAS MUSIC TIMER COUNTED DOWN?
        LD      A,(HL)
        AND     A
        JR      Z,TBIN2         ; YEP - PLAY NEXT NOTE
        DEC     (HL)            ; ELSE DECREMENT IT
        JR      NZ,INTDON       ; JUMP IF NOT NOW ZERO
        XOR     A
        OUT     (TONEA),A
        JR      TBINX           ; Silence A Stacato

; MUSIC TIMER IS AT ZERO - ARE NEW PARAMETERS READY?
TBIN2:  INC     HL              ; STEP TO NEW TIMER VALUE
        OR      (HL)            ; IS IT NON ZERO?
        JR      Z,INTDON        ; JUMP IF NOT
        DEC     HL              ; ELSE SET OFFICIAL TIMER
        LD      (HL),A          ; SAY WE GOT IT
        INC     HL
        LD      (HL),$00
        INC     HL
        LD      A,(HL)          ; SET NEW MASTER
        OUT     (TONMO),A
        LD      (HL),OA2        ; Restore Center Octave = 71
        INC     HL
        LD      A,(HL)          ; AND NEW TONE
        OUT     (TONEA),A
        AND     A               ; REST WANTED?
        JR      Z,INTDON        ; YES - JUMP AROUND VOLUME UPDATE
        LD      A,$0F
TBINX:  OUT     (VOLAB),A
; SET COLOR REGISTERS TO VALUES IN PARAMETER VARS %0 AND %1
INTDON: LD      A,(DEVCL0)     ;* Get BC
        OUT     (COL0L),A
        OUT     (COL1L),A
        LD      A,(DEVCL1)     ;* Get FC
        OUT     (COL2L),A
        OUT     (COL3L),A
; DONE - RESTORE REGISTERS AND GO BACK
        POP     HL
        POP     DE
        POP     BC
        JR      LPIEX

;************************************************
;*      Light pen interrupt processor           *
;************************************************
;
LPINT:  PUSH    AF
        EXX
        IN      A,(SW2)        ;* Collect at least 4 1s to start
        RRA                    ;* Then wait on a 0 (Start bit)
        LD      A,C            ;* Collect 8 bits, then wait for
        RRA                    ;*  another start bit.
        LD      C,A            ;* Move old data to hi C
        LD      A,B
        AND     A
        JP      M,LPI1         ;* Minus means collecting 4 1s
        JR      NZ,LPI2        ;* NZ means collecting data
        BIT     7,C            ;* Else waiting on start bit
        JR      NZ,LPI3        ;* Leave unless start bit found
        LD      B,$08          ;* Now collect 8 data bits
        JR      LPI3

LPI1:   INC     B              ;* Increment 1 collector
        BIT     7,C
        JR      NZ,LPI3        ;* Good if a 1
        LD      B,$FC          ;* Else reset collector
        JR      LPI3

LPI2:   DJNZ    LPI3           ;* Leave unless 8 bits collected
        LD      HL,(TAPINS)
        LD      A,L            ;* Get insert pointer
        CALL    RAMPIT         ;* Update for next
        CP      H
        JR      Z,LPI3         ;* Buffer is jammed; forget it!
        LD      (TAPINS),A     ;* Save insert pointer
        LD      H,TAPBUF >> 8   ; $4E [point back to $4E00+TAPINS]
        LD      (HL),C
LPI3:   EXX
LPIEX:  POP     AF
        EI
        RET

; Ramp pointer and reset to start of TAPe BUFfer if past end
;
RAMPIT: INC     A
        CP      TXTUNF & $FF    ; not to TAPBUF+$30 yet ?
        RET     NZ
        LD      A,TAPBUF & $FF
        RET

;* Prepare for tape input
;
;* :INPUT, :LIST and :RUN call this routine
;
TVLLNK: DI
        LD      HL,$2222        ; (TAPBUF & $FF) + ((TAPBUF & $FF) << 8)
        LD      (TAPINS),HL     ; ... sets both pointers to buffer start
        EXX
        XOR     A
        LD      (DEVTEM),A     ;* No notes
        INC     A
        LD      (CHMODE),A
        LD      B,$FC
        EXX
        LD      A,$18           ; Screen AND LightPen Interrupts
        OUT     (INMOD),A
        EI

if NORML ; ### conditional assembly ### {else code deleted for TESTC}
        RST     RSTIGN         ;* Get next non-blank from (DE)

        CALL    ZONATNL         ; do Zero ON AT NewLine or ;
        RET     Z
        CALL    EXPR            ; Same as RST RSTEXP  ;* Evaluate expression
        PUSH    DE
TVL1:   PUSH    HL
        CALL    CHKIO          ;* Get tape character
        POP     HL
TVL2:   CP      H
        JR      NZ,TVL1
        PUSH    HL
        CALL    CHKIO          ;* Get tape character
        POP     HL
        CP      L               ; #   #
        JR      NZ,TVL2         ; # - #
        POP     DE              ; #   #
endif ; ##### end conditional #########

; SUBROUTINE TO RETURN ZERO STATUS IF CHARACTER IN A
; IS NL OR ';'  [ab combined with RSTIGN for IGNATNL]
;
ZONATNL:
        CP      ';'             ; CHECK FOR CONTINUATION
        RET     Z
        CP      CR              ; AND FOR CR
        RET

; ENTRY TO LOAD PROGRAM [NOT ab COMBINED SCREEN AND PGM]
; note: Pressing ANY KEY will cancel the tape input mode
;
; :INPUT COMMAND  ;* - Load BASIC program into memory
; Any characters read in from tape will display on TV
; and be executed as if they were input by the KeyPad.
;
TINPUT: CALL    TVLLNK          ; [ab only ?? AND ARGS?]  do OPEN for Tape Input
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; :LIST command  ;* - List BASIC tape
; note: displays information on tape WITHOUT saving to memory
;
TVLIST: CALL    TVLLNK          ; do Prepare for Tape Input
TVLIL:  CALL    CHKIO           ; do Read a character from cassette tape
        RST     RSTOUT         ;* Output Char. in A
        JR      TVLIL

; *PRINT Routine  ;* - Print BASIC program onto printer
;
POUTPU: LD      A,$06
        DB      $01             ; does a LD BC,$023E instead of LD A,$02
;* Skips 2 bytes
; :PRINT Routine  ;* - Print BASIC program to tape
;
TOUTPU: DB      $3E             ; does a LD A,$02
        DB      $02
        LD      (CHMODE),A
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

if NORML ; ### conditional assembly ### {else code deleted for TESTC}
; :RUN COMMAND - LOADS 128 byte BOOTSTRAP INTO RAM
; AND JUMPS TO IT  ;* - Load tape to $4000-$407F and execute
TLOAD:  CALL    TVLLNK          ; do Prepare for Tape Input
        LD      HL,$4000        ; HL=SCREEN TOP
        PUSH    HL

; SUBROUTINE TO INPUT A BLOCK, HL=STORE ADDR
; FIRST - AN ENTRY TO REVEAL FEEDBACK AREA
;
INBLK:  PUSH    HL
        CALL    CHKIO           ; do Read a character from cassette tape
        POP     HL
        LD      (HL),A
        INC     HL
        BIT     7,L             ; #   #
        JR      Z,INBLK         ; # - #
        RET                     ; #   #
endif ; ##### end conditional #########

; *** Calculator Routine as $+@(0),@(18),@(0) *** and $- $x or $divide
;
; Call with type of calculation followed by first BCD string address,
; then a comma, the second BCD string address, another comma, finally
; the BCD string address to store the result in.  Each string element
; can be a digit 0-9 or ASCII '0' to '9', the result is always ASCII.
;
; The 18 byte string is arranged backwards as a sign (0 = + or 8 = -),
; an overflow byte (must be initialize to zero), eight integer digits,
; and eight fractional digits.  Typically the @() array is used thus:
;
; @(17)  @(16)  @(15) through @(8)  implied decimal  @(7) through @(0)
; Sign Overflow  Most Significant down to  .  Least Signigicant digit.
;
;
;* $ Calculator interface routine
;* $<sign>,<arg1>,<arg2>,<arg3> means <arg3>=<arg1>,<sign>,<arg2>
;
DOLLAR:                        ;* Get 1st character after $
        RST     RSTIGN         ;* Get next non-blank from (DE)
        INC     DE
        PUSH    AF             ;* Save sign
        CALL    TSTVFF         ;* Get VRBL storage adrs.
        PUSH    DE
        LD      DE,BCDN1       ;* Data 1 adrs.
        CALL    BCDSET         ;* Insert <arg1>
        POP     DE
        TSTCC   COMMA,PIXDUD   ;* Comma = Char. to check, Jump if no match
        CALL    TSTVFF         ;* Get VRBL storage adrs.
        POP     AF             ;* Rearrange stack
        PUSH    DE
        LD      DE,BCDN2       ;* Data 2 adrs.
        PUSH    AF
        CALL    BCDSET         ;* Insert <arg2>
        LD      DE,BCDN1       ;* Regain sign
        POP     AF             ;*
        LD      B,$09          ;* 18 digits
        CALL    BCDDO          ;* Do the math
        POP     DE             ;* Get input pointer
        TSTCC   COMMA,PIXDUD   ;* Comma = Char. to check, Jump if no match
        CALL    TSTVFF         ;* Get VRBL storage adrs.
        PUSH    DE
        LD      DE,BCDN1       ;* Data 1 adrs.
        LD      BC,$1200
DLOOP:  EX      DE,HL
        SYSTEM  INDEXN         ;* Get BCD digit

        ADD     A,$30          ;* Convert BCD to ASCII
        EX      DE,HL
        CALL    STHL           ;* Save @ (HL) [interlaced into TeXT if necessary]
        INC     HL
        INC     HL
        INC     C
        DJNZ    DLOOP          ;* Do 18 of them
        POP     DE
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; FUNCTION TO RETURN STATE OF ADDRESSED PIXEL
; IE... PIX(X,Y)= 1 IF PIXEL IS 1, 0 IF 0
;
;* PX - Check screen dot
;* PX(<expr1>,<expr2>)
;
PIXFUN: TSTC    '(',PIXDUD     ;* Open = Char. to check, Jump if no match
        PUSH    BC
        RST     RSTEXP         ;* Evaluate expression
        PUSH    HL             ;* Save value of <expr1>
        TSTCC   COMMA,PIXDUD   ;* Comma = Char. to check, Jump if no match
        RST     RSTEXP         ;* Evaluate expression
        TSTC    ')',PIXDUD     ;* Close = Char. to check, Jump if no match
        POP     BC             ;* X value
        PUSH    DE              ; SAVE PTR  ;* Save text pointer
        LD      D,L            ;* D = Y
        LD      E,C            ;* E = X
        CALL    R2ABS          ;* Get odd crt adrs to A
        EX      DE,HL          ;* and adrs to DE
        SYSSUK  INDEXB          ; INDEX BYTE (SYSTEM SUBROUTINE)
        DW      PIXTBL          ; HL + A [not loaded!] to HL

        LD      A,(DE)          ; GET BYTE FROM SCREEN  ;* Get CRT dots
        AND     (HL)            ; MASK OFF NONSENSE  ;* AND with mask
        LD      H,$00
        LD      L,H
        POP     DE
        POP     BC
        RET     Z              ;* No dot
        INC     HL
        RET                     ;* Dot on

; SUBROUTINE TO GET VARIABLE MAKING SURE IT IS ONE
;
TSTVFF: CALL    TSTV           ;* Get VRBL storage adrs.
        RET     NC              ; GO BACK IF GOOD  ;* Was a variable
; ELSE FALL INTO...
PIXDUD: JP      QWHAT

BCDDO:  CP      $62             ; BallyASCII Multiplication sign
        JR      NC,BCDX        ;* Jp if Mult or Divide
        CP      '-'
        JR      Z,BCDSB
        SYSTEM  BCDADD         ;* Add
        RET

BCDSB:  SYSTEM  BCDSUB         ;* Subtract
        RET

BCDX:   JR      NZ,BCDDV       ;* Jp if divide
        SYSTEM  BCDMUL         ;* Multiply
        RET

BCDDV:  SYSTEM  BCDDIV         ;* Divide
        RET

BCDSET: EX      DE,HL
        LD      BC,$1200       ;* 18 digits
BCDLP:  CALL    LDE            ;* Get data from storage [load from TeXT if necessary]
        SYSTEM  STOREN         ;* Replace BCD digit

        INC     C              ;* Next digit
        INC     DE             ;* Next storage location
        INC     DE
        DJNZ    BCDLP          ;* Do 18 of them
        RET

; BOX DRAW ROUTINE  ;* - Draw a box on the screen
;* BOX(<x>,<y>,<xsize>,<ysize>,<type>)
;
BOXDRW: RST     RSTEXP          ; GET X  ;* Evaluate expression
        PUSH    HL             ;* Save starting x
        TSTCC   COMMA,BOXDUD   ;* Comma = Char. to check, Jump if no match
        RST     RSTEXP          ; GET Y  ;* Evaluate expression
        PUSH    HL             ;* Save starting y
        TSTCC   COMMA,BOXDUD   ;* Comma = Char. to check, Jump if no match
        CALL    GETOK          ;* Get Expr., Range 1-255 [0 asks HOW?]
        PUSH    AF             ;* Save xsize
        TSTCC   COMMA,BOXDUD   ;* Comma = Char. to check, Jump if no match
        CALL    GETOK          ;* Get Expr., Range 1-255 [0 asks HOW?]
        PUSH    AF             ;* Save ysize
        TSTCC   COMMA,BOXDUD   ;* Comma = Char. to check, Jump if no match
        RST     RSTEXP         ;* Get box type  ;* Evaluate expression
        PUSH    DE             ;* Save text pointer
        POP     IX             ;*  in IX
        POP     AF              ; RESTORE YS
        LD      B,A            ;* Get ysize to B [ab just uses POP BC !]
        POP     AF              ; AND XS
        LD      C,A            ;* Get xsize to C
        LD      A,L             ; PRESERVE FLAG  ;*  Get box type to A
        POP     HL
        LD      D,L            ;* Get start y to D
        POP     HL
        LD      E,L            ;* Get start x to E
        LD      L,A
; NOW WE HAVE: B=YS, C=XS, D=Y, E=X, L=FLAG
; LIMIT CHECK Y
        LD      H,B
        DEC     H
        SRL     H
        LD      A,D
        CALL    SABS            ; do Set to ABSoulte value
        ADD     A,H
        CP      $2C
        JR      NC,BOXNDR
        LD      A,D
        ADD     A,H
        LD      D,A
; AND X
        LD      H,C
        SRL     H
        LD      A,E
        CALL    SABS            ; do Set to ABSoulte value
        ADD     A,H
        CP      $51
        JR      NC,BOXNDR
        LD      A,E
        SUB     H
        LD      E,A
; DIDDLE WITH FLAG BYTE
        LD      A,L
        AND     $03             ; MODULO 4
        JR      Z,BOXNDR        ; SKIP DRAW IF ZERO
        SUB     $02             ; ELSE SUBTRACT 2 FOR MASK
        PUSH    AF
        CALL    R2ABS           ; do Relative TO ABSoulte conversion
; HL = ABS ADDR, A = SA, B=YS, C=XS
        OUT     (MAGIC),A
        POP     AF
        CALL    BOXPUT          ; do draw a BOX PUT on screen
BOXNDR:
        PUSH    IX
        POP     DE
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

BOXDUD: JP      QWHAT

; Set A to ABSoulute value
;
SABS:   AND     A
        RET     P
        NEG
        RET

; SUBROUTINE TO DRAW A BOX ON SCREEN
;
BOXPUT: LD      E,A
        LD      A,C             ; D = X / 4
        RRCA
        RRCA
        AND     $3F
        INC     A
        LD      D,A
; PAINT FULL BOX STRIPES
MPT1:   DEC     D
        JR      Z,MPT2
        LD      A,10101010B
        CALL    STRIPE          ; do draw a STRIPE on screen
        JR      MPT1

MPT2:   LD      A,C
        AND     $03
        INC     A
        LD      C,A
        XOR     A
MPT3:   DEC     C
        JR      Z,MPT4
        RRCA
        RRCA
        OR      10000000B
        JR      MPT3

MPT4:   CALL    STRIPE          ; do draw a STRIPE on screen
        XOR     A
; FALL INTO...
; SUBROUTINE TO PAINT A STRIPE
;
STRIPE: PUSH    HL
        PUSH    BC
        LD      (WASTER),A
        LD      A,(WASTER + $4000)
        LD      C,A
STRP1:  LD      A,E
        CP      $01
        JR      NZ,STRP2
        LD      A,(HL)
        XOR     C
STRP2:  XOR     (HL)
        AND     C
        XOR     (HL)
        LD      (HL),A
        LD      A,L
        ADD     A,$28
        LD      L,A
        LD      A,H
        ADC     A,$00
        LD      H,A
        DJNZ    STRP1
        POP     BC
        POP     HL
        INC     HL
        RET

GETOK:  RST     RSTEXP         ;* Evaluate expression
        LD      A,H
        OR      A
        JR      NZ,LINEDX      ;* Jp if over 255
        OR      L
        JR      Z,LINEDX       ;* Jp if = 0
        RET

; LINE DRAWER  ;* - Draw a line on the screen
;* LINE(<x>,<y>,<type>)
;
LINEDR: RST     RSTEXP         ;* Evaluate expression
        LD      A,L
        PUSH    AF             ;* Save starting x
        TSTCC   COMMA,LINEDX   ;* Comma = Char. to check, Jump if no match
        RST     RSTEXP         ;* Evaluate expression
        LD      A,L
        PUSH    AF             ;* Save starting y
        TSTCC   COMMA,LINEDX   ;* Comma = Char. to check, Jump if no match
        RST     RSTEXP         ;* Evaluate expression
        LD      B,H
        LD      C,L
        PUSH    DE
        POP     IX
        LD      DE,(OLDXY)     ;* Current xy [Y is high order byte, X is lower byte]
        POP     AF
        LD      H,A
        POP     AF
        LD      L,A
        CALL    RANG1            ; do check the RANGe of CX
        JR      NC,LINED1      ;* Jp if out of range
        LD      A,H
        CALL    RANG2            ; do check the RANGe of CY
        JR      NC,LINED1      ;* Jp if out of range
        LD      (OLDXY),HL      ; SET NEW LAST PLACE  ;* Update xy
; DIDDLE WITH FLAG BYTE
        LD      A,C
        AND     $03
        JR      Z,LINED1
        SUB     $02
        LD      (PIXVAL),A      ; SET PIXVAL
        CALL    DVECT           ; do Draw line VECTor

LINED1: PUSH    IX
        POP     DE
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

LINEDX: JP      QHOW

; LARRY LIVERMORE'S VECTOR DRAWING ALGORITHM
; H=Y1, L=X1, D=Y2, E=X2
;
DVECT:  PUSH    DE
        LD      B,L
        LD      C,E
        CALL    CDELTA          ; do Compute DELTA for X
        LD      E,B
        LD      L,C
        LD      B,H
        LD      C,D
        CALL    CDELTA          ; do Compute DELTA for Y
        LD      H,C
        LD      D,B
; NOW WE HAVE: H=SGN(DY), L=SGN(DX)
; D=ABS(DY), E=ANS(DX)
        LD      (INCRO),HL
; DECIDE WHICH DELTA IS LARGER
; CALL  BIGGER MX, SMALLER MN
        LD      C,$00
        LD      A,D
        CP      E
        JR      C,VECT1
        LD      D,E
        LD      E,A
        INC     C
VECT1:  LD      A,D             ; MX TO A
        SRL     A
        LD      B,A
        EX      DE,HL
        LD      (MNMX),HL
        POP     DE
        LD      A,L
        INC     A               ; MAKE SURE LAST PIXEL WRITTEN
; THE INFAMOUS PIXEL PAINTING LOOP
VECT2:  PUSH    AF
        CALL    R2ABS           ; do Relative TO ABSoulte conversion
        PUSH    BC
        PUSH    HL
        LD      C,A
        LD      B,$00
        LD      HL,PIXTBL
        ADD     HL,BC
        LD      B,(HL)
        POP     HL
        LD      A,(PIXVAL)
        CP      $01
        JR      NZ,VECT9
        LD      A,(HL)
        XOR     B
VECT9:  XOR     (HL)
        AND     B
        XOR     (HL)
        LD      (HL),A
        POP     BC
; INCREMENT COORDINATES
        LD      HL,(MNMX)
        LD      A,B
        ADD     A,H
        CP      L               ; DID WRAP AROUND UNIVERSE?
        JR      C,VECT4
        SUB     L
        LD      B,A
        LD      HL,(INCRO)
        LD      A,D
        ADD     A,H
        LD      D,A
VECT3:  LD      A,E
        ADD     A,L
        LD      E,A
        JR      VECT5

VECT4:  LD      B,A
        LD      HL,(INCRO)
        LD      A,C
        RRCA
        JR      NC,VECT3
        LD      A,D
        ADD     A,H
        LD      D,A
; END OF LOOP
VECT5:  POP     AF
        DEC     A
        JR      NZ,VECT2
        RET

RANG1:  CP      $50            ;* Check CX range [-80 to 79]
        RET     C
        CP      $B0
        CCF
        RET

RANG2:  CP      $2C            ;* Check CY range [-44 to 43]
        RET     C
        CP      $D4
        CCF
        RET

; SUBROUTINE TO LOAD HL WITH VDM COORDINATES
; FROM DEVICE VARIABLES
;
LDVDMC: PUSH    AF
        LD      A,(VDMY)
        CPL
        ADD     A,$29
        CP      $51             ; OUT OF RANGE?
        JR      C,LDVDM1        ; NO
        XOR     A
LDVDM1: LD      H,A
        LD      A,(VDMX)        ; DIDDLE WITH X
        ADD     A,$4D
        CP      $9D
        JR      C,LDVDM2
        XOR     A
LDVDM2: LD      L,A
        POP     AF
        RET

; SUBROUTINE TO STORE HL INTO VDM COORDINATE DEVICE VARIABLES
;
STVDMC: PUSH    HL
        LD      A,H
        SUB     $29
        CPL
        LD      L,A
        CALL    SGNEXT          ; do SiGN EXTend from L into H
        LD      (VDMY),HL      ;* Update CY
        POP     HL
        LD      A,L
        SUB     $4D
        LD      L,A
        CALL    SGNEXT          ; do SiGN EXTend from L into H
        LD      (VDMX),HL      ;* Update CX
        RET

; SUBROUTINE TO COMPUTE DELTA AND INCREMENT FOR TWO COORDINATES
;
CDELTA: PUSH    HL
        PUSH    DE
        LD      L,C
        CALL    SGNEXT          ; do SiGN EXTend from L into H
        EX      DE,HL
        LD      L,B
        CALL    SGNEXT          ; do SiGN EXTend from L into H
        XOR     A
        SBC     HL,DE
; COMPUTE SGN(DELTA) AND ABS(DELTA)
        OR      H
        JR      Z,CDELT1
        LD      C,A
        LD      A,L
        NEG
        LD      B,A
        JR      CDELT3

CDELT1: OR      L               ; POS CASE 0?
        JR      Z,CDELT2
        LD      A,$01
CDELT2: LD      B,L
        LD      C,A
CDELT3: POP     DE
        POP     HL
        RET

; ...
; RELATIVE TO ABSOLUTE CONVERSTION
;
R2ABS:  PUSH    DE             ;* Save XY
        LD      A,D            ;* Get y
        CPL                    ;* Reverse sense
        ADD     A,$2C          ;* Make it 0-87
        LD      D,A            ;* Put it back
        LD      A,E
        ADD     A,$50          ;* Same for x [0-159]
        LD      E,A
        XOR     A
        SYSTEM  RELAB1         ;* Get CRT adrs to DE

        EX      DE,HL
        POP     DE             ;* Regain original XY
        RET

; KB - FUNCTION TO RETURN NEXT CHARACTER FROM KEYBOARD
;
GETKB:  PUSH    BC
        PUSH    DE
        CALL    CHKIO           ; do Read a character from keyboard
        POP     DE
        POP     BC
        LD      L,A            ;* HL is output register
        LD      H,$00
        RET

; DEVICE VARIABLE TO OUTPUT TO REFERENCED IO PORT
;* OUTPUT &(<expr>)=
;
PUTIO:  RST     RSTPAR          ; GET PORT #  ;* Get value of () or storage adrs
        TSTC    '=',PUTCD2      ; GET EQUALS  ;* Jump if no match
        PUSH    HL              ; SAVE PORT #
        RST     RSTEXP          ; EVALUATE EXPRESSION FOLLOWING
        LD      A,L             ; A=VALUE TO OUTPUT
        POP     HL              ; RESTORE PORT #
        PUSH    BC
        LD      B,H
        LD      C,L
        OUT     (C),A           ; IT    1
        POP     BC
        RST     RSTFIN          ; GO HOME  ;* cr. or ; otherwise, WHAT?

; FUNCTION TO RETURN VALUE OF A GIVEN IO PORT
;* INPUT =&(<expr>)
;
IOFUN:  RST     RSTPAR         ;* Get value of () or storage adrs
        PUSH    BC              ; GET PORT NUMBA
        LD      B,H
        LD      C,L
        IN      A,(C)
        LD      L,A
        LD      H,$00
        POP     BC
        RET

; DEVICE VARIABLE TO PLAY NOTE WITHOUT PRINTING [via MU=]
;
PUTMU:  TSTC    '=',PUTCD2     ;* Equals = Char. to check, Jump if no match
        RST     RSTEXP         ;* Evaluate expression
        LD      A,L
        CALL    PNOTE           ; do Play NOTE tone for key in A
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; DEVICE VARIABLE TO OUTPUT CHARACTER ON VDM [via TV=]
;
PUTCD:  TSTC    '=',PUTCD2     ;* Equals = Char. to check, Jump if no match
        RST     RSTEXP         ;* Evaluate expression
        LD      A,L
        RST     RSTOUT         ;* Output Char. in A
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

PUTCD2: JP      QWHAT

; ROUTINE TO TRANSFER CONTROL TO ASSEMBLY LANGUAGE SUBROUTINE
;* CALL <expr>
;
DOCALL: LD      HL,BBRET        ; PUSH RETURN ADDR ON STACK
        PUSH    HL
        RST     RSTEXP          ; GET ADDRESS  ;* Evaluate expression
        JP      (HL)            ; AND JUMP TO IT

; :RETURN to close off the tape input port
;
TCLOSE: CALL    INIT0           ; do INITialize interrupts to 0
BBRET:  RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

;* Initialize interrupts to Default
;
INIT0:  IN      A,(SW2)         ; $12 for 300 Baud Interface ??
        AND     $02
        JR      NZ,INIT0        ; Loop on Down ??
        LD      (CHMODE),A      ; Zero
        LD      A,$03
        LD      (DEVTEM),A     ;* Preset Note Time
        DI
        IM      2
        LD      A,ITAB >> 8    ;* Interrupt Page
        LD      I,A
        LD      A,$08           ; Normal Screen Interrupt only
        OUT     (INMOD),A
        LD      A,$C8          ;* Interrupt every 200 lines
        OUT     (INLIN),A       ; [actually on every line 200 !]
        LD      A,ITAB & $FF    ; Set TBIINT as Interrupt
        OUT     (INFBK),A      ;* Interrupt vector
        EI
        RET

; ** TINY BASIC EXECUTION STARTS HERE **
; CLEAR WHOLE KIT AND KABOOBLE
;
;***********************
;*      Cold Start     *
;***********************
;
BEGIN:  XOR     A
        OUT     (MAGIC),A       ; Set up port $0C
        LD      H,A            ;* Clear $4000-$4FFF
        LD      L,A
        LD      B,A
    ; [ab added MAKE SURE SHIFTER FLUSHED code here]
BEGIN1: LD      (HL),B
        INC     HL
        LD      A,H
        CP      $50
        JR      NZ,BEGIN1
        LD      SP,SYSRAM

        SYSTEM  INTPC          ;* Start multiple Subr.

        DO      SETOUT
        DB      $B0            ;* Display height
        DB      00101100B      ;* Border [$2C or 44] color 0, Left
        DB      $08            ;* Normal interrupts

        DO      EMUSIC         ;* Kill sound

; INITIALIZE DEVICE VARIABLES
        DO      SETB            ; STORE BYTE (SYSTEM ROUTINE)
        DB      OA2             ; $47 for Dick Answorth notes
        DW      MUZMO           ; for Master Oscillator

        DO      MOVE            ; MOVE BYTES (SYSTEM ROUTINE)
        DW      DEVVAR
        DW      $000A          ;* Move 10 bytes from
        DW      INIDEV         ;* $201D to $4EA2

        DO      MOVE            ; MOVE BYTES (SYSTEM ROUTINE)
        DW      ALTFON
        DW      $0007          ;* Move 7 bytes from
        DW      FNTSYS         ;* $0206 to $4E66

        DO      SETW            ; STORE WORD (SYSTEM ROUTINE)
        DW      $06A0
        DW      ALTFON         ;* Char spacing= 6, table base [still] = $A0

        DO      SETW            ; STORE WORD (SYSTEM ROUTINE)
        DW      TXT + 4
        DW      TXTUNF         ;* LD (TXTUNF),$A004 [in virtual TeXT area] {INROM note: $3004 [in ROM]}

if NORML ; ### conditional assembly ### {same result !!}
        DO      XINTC          ;* # Y # End multiple Subr.
else ; TESTC ####### conditional ###### else...
        DONT    XINTC          ;* # N # End multiple Subr.
endif ; ##### end conditional #########

        LD      HL,TXT + 1      ; TeXT + 1 init to $FF (or -1) End of Program marker {INROM: $3001 [in ROM]}
        LD      A,$FF
        CALL    STHL            ; STore A by HL [interlaced into TeXT if necessary] {INROM: write to ROM !!}
RINIT:  CALL    INIT0           ; do INITialize interrupts to 0
INIT:   CALL    CRLF            ; do display a Carriage Return (and Line Feed)
TELL:   LD      DE,BBASIC       ; "BALLY BASIC",cr text
        CALL    PRTSTG          ; do PRinT STrinG to TV
;
; DIRECT COMMAND - TEXT COLLECTOR
;
; STOP command
;
STOP:
RSTART: LD      SP,STACKP       ; RANSHT precludes MUZCPU and Counter Timers
        LD      HL,XXST1 + 1
        LD      (CURRNT),HL
XXST1:  LD      HL,$0000
        LD      (LOPVAR),HL
        LD      (STKGOS),HL
XXST2:  LD      A,'>'
        CALL    GETLN           ; do GET a LiNe
        PUSH    DE
        LD      DE,BUFFER
        LD      A,(DE)
        CP      '>'
        JR      NZ,XXST3
        INC     DE
XXST3:  CALL    TSTNUM         ;* Get possible line number
        RST     RSTIGN         ;* Get next non-blank from (DE)
        LD      A,H
        OR      L
        POP     BC             ;* BC = end of line
        JR      Z,EXEC0        ;* Direct mode if no line #
        LD      (OLDLN),HL
        DEC     DE             ;* Put binary line number in
        LD      A,H            ;*  front of first significant
        LD      (DE),A         ;*  character of line in input
        DEC     DE             ;*  buffer
        LD      A,L
        LD      (DE),A
        PUSH    BC             ;* Line begin address
        PUSH    DE             ;* Line end address
        LD      A,C
        SUB     E
        PUSH    AF             ;* A = # bytes in line
        CALL    FNDLN          ;* Find this line in SAVE area
        PUSH    DE             ;* DE = adrs
        JR      NZ,XXST4       ;* Jp if not found; insert
        PUSH    DE             ;* Found, delete it
        CALL    FNDNXT         ;* Find next line
        POP     BC             ;* Start adrs of line to delete
        LD      HL,(TXTUNF)    ;* End of all text
        CALL    MVUP           ;* Move up to delete
        LD      H,B            ;* Save new text end address
        LD      L,C
        LD      (TXTUNF),HL
XXST4:  POP     BC             ;* Adrs of where to insert
        LD      HL,(TXTUNF)    ;* Text end address
        POP     AF             ;* Length of new line
        PUSH    HL             ;* Save text last adrs.
        CP      $03            ;* Length = 3, delete only
        JR      Z,RSTART
        ADD     A,L            ;* Compute new text end
        LD      E,A            ;*   to DE
        LD      A,$00
        ADC     A,H
        LD      D,A
        LD      HL,DFTLMT      ;* Last possible address {INROM note: $3FFF [in ROM]}
        EX      DE,HL
        CALL    COMP            ; do COMPare HL and DE
        JP      NC,QSORRY      ;* SORRY if no room
        LD      (TXTUNF),HL    ;* Save new text end
        POP     DE             ;* Old text end
        CALL    MVDOWN          ; do MoVe a block DOWN
        POP     DE             ;* New line start
        POP     HL             ;*          end
        CALL    MVUP           ;* Move line to SAVE
        JR      XXST2          ;* Get next line

; DIRECT AND EXEC  ;* Direct Execute
;
EXEC0:  RST     RSTIGN          ; GET FIRST     NONBLANK  ;* Get next non-blank from (DE)
        PUSH    DE              ; SAVE POINTER
        CP      $68             ; IS SHE A TOKEN?  ;* Is this a word?
        JR      C,EXEC0A        ; NO
        CP      $75            ;* Yes, sure?
        JR      NC,EXEC0A      ;* No, assume implied LET
; WE FOUND A TOKEN - LOOKUP IN TABLE AND JUMP TO IT
        RLCA
        LD      E,A
        LD      D,$00
        LD      HL,TOKJT - $D0 ;* Jump table [TOKJT - (2 * $68)]
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        EX      DE,HL
        POP     DE
        INC     DE
        JP      (HL)           ;* Go to proper routine

; NOT A TOKEN - A VARIABLE PERHAPS?
EXEC0A: CALL    TSTV            ; TEST FOR VARIABLE  ;* Get VRBL storage address
        JR      C,EXEC0B        ; NO - SEARCH   1
        TSTC    '=',EXEC0B     ;* Equals = Char. to check, Jump if no match
        POP     BC
        CALL    SETV1           ; ASSIGNMENT    1
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

EXEC0B: POP     DE
        LD      HL,TAB2 - 1
EXEC:   RST     RSTIGN          ; EXEC  ;* Get next non-blank from (DE)
        PUSH    DE              ; SAVE POINTER
EX1:    CALL    LDE             ; ZAPPED LDE [load from TeXT if necessary]
        INC     DE
        INC     HL
        CP      (HL)
        JR      Z,EX1
        LD      A,$7F
        DEC     DE
        CP      (HL)
        JR      C,EX5
EX2:    INC     HL
        CP      (HL)
        JR      NC,EX2
        INC     HL
        POP     DE
        JR      EXEC

EX5:    LD      A,(HL)          ; LOAD HL WITH THE JUMP
        INC     HL              ; ADDRESS FROM TABLE
        LD      L,(HL)
        AND     $7F
        LD      H,A
        POP     AF
        JP      (HL)

; CLEAR COMMAND
;
; Clear Screen routine
CLRSCR: LD      HL,NORMEM
        LD      BC,$0E10
CLRLP:  LD      A,(HL)
        AND     01010101B
        LD      (HL),A
        INC     HL
        DEC     BC
        LD      A,B
        OR      C
        JR      NZ,CLRLP
; RESET VDM GOODIES
        PUSH    DE
        SYSSUK  MOVE
        DW      VDMX
        DW      $0006          ;* Move 6 bytes from
        DW      INIVDM          ; INIDEV Part 2 to $4EA8

        POP     DE
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; RUN routine(s)
;
RUN:    LD      DE,TXT          ; $A000 {INROM note: $3000 [in ROM]}
; RUn NeXt One
RUNX1:  LD      HL,$0000       ;* RST30 Jumps here on cr
        CALL    FNDLP          ;* Find next line [starting at Pointer]
        JP      C,RSTART       ;* Passed end; quit
; RUN The goSub Line
RUNTSL: EX      DE,HL
        LD      (CURRNT),HL    ;* Set CURRNT to line address
        EX      DE,HL
        INC     DE             ;* Bump past line number
        INC     DE
; RUN SaMe Line  ;* RST30 Jps to RUNSML on ;
RUNSML: CALL    WHATSU          ; CHECK FOR INTERRUPT KEY
        JP      EXEC0          ;* Continue Same line execution [close enough for JR]

; GOTO routine
;
GOTO:   RST     RSTEXP         ;* Evaluate expression
        PUSH    DE             ;* Save for error routine
        CALL    FNDLN          ;* Find target line
        JP      NZ,AHOW        ;* No such line
        POP     AF             ;* Clear stack
        JR      RUNTSL

; LIST AND PRINT
;
;* LIST [<expr1>][,<expr2>]
LISTCOM:
        LD      HL,$0000        ; ASSUME AT EOL  ;* Preset to list from beginning
        RST     RSTIGN         ;* Get next non-blank from (DE)
        CALL    ZONATNL         ; do Zero ON AT NewLine or ;
        JR      Z,LIS1         ;* Jp if ; or cr
        CP      ','             ; LEADING COMMA?  ;* Jp if only # lines specified
        JR      Z,LIS1          ; YEP - SKIP FIRST EXPR GET
; NOT AT FIRST - GET FIRST EXPR
        RST     RSTEXP         ;* Evaluate expression
LIS1:   PUSH    HL             ;* Save line # for start
        LD      HL,$FFFF       ;* Set for max number of lines
        TSTCC   COMMA,LIS2     ;* Comma = Char. to check, Jump if no match
        RST     RSTEXP         ;* Evaluate expression  ;* Get number of lines
LIS2:   PUSH    DE
        POP     IY
        EX      (SP),HL
        CALL    FNDLN           ; do FiND HL Line Number in TeXT
LIS3:   JR      C,LSQUIT
        EX      (SP),HL
        LD      A,H
        OR      L
        JR      Z,LSQUIT
        DEC     HL
        EX      (SP),HL
        CALL    PRTLN           ; do PRinT Line Number then Space
        CALL    PRTSTG          ; do PRinT STrinG to TV
        CALL    WHATSU          ; do Check for PAUSE or ABORT keys
        CALL    FNDLP           ; do FiND Linenumber starting at Pointer
        JR      LIS3

LSQUIT: PUSH    IY
        POP     DE
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; PRINT routine
;
PRINT:  LD      C,$08           ; C=# OF SPACES  /* Default number of spaces
        TSTCC   $3B,PRT1        ; IF NULL LIST & ";"  ;* Jump if no match
        CALL    CRLF            ; GIVE CR-LF AND
        JR      RUNSML          ; CONTINUE SAME LINE

PRT1:   TSTCC   CR,PRT5         ; IF NULL LIST (CR)  ;* Jump if no match
        CALL    CRLF            ; GIVE CR-LF AND
        JR      RUNX1           ; CONTINUE SAME LINE

PRT2:   TSTC    '#',PRT3        ; ELSE IS IT FORMAT?  ;* Jump if no match
        RST     RSTEXP          ; YES, EVALUATE EXPR.
        LD      A,$C0          ;* Limit to 6 bits
        AND     L
        OR      H
        JP      NZ,QHOW
        LD      C,L             ; AND SAVE IT IN C
        JR      PRT4            ; LOOK FOR MORE TO PRINT

PRT3:   CALL    QTSTG           ; OR IS IT A STRING?
        JR      PRT8            ; IF NOT, MUST BE EXPR.

PRT4:   TSTCC   COMMA,PRT7      ; IF COMMA, GO FIND NEXT  ;* Jump if no match
PRT5:   TSTCC   COMMA,PRT6     ;* Comma = Char. to check, Jump if no match
        LD      A,$20
        RST     RSTOUT          ; Output SPACE in A
        JR      PRT5

PRT6:   CALL    FIN             ; IN THE LIST.
        JR      PRT2            ; LIST CONTINUES

PRT7:   CALL    CRLF            ; LIST ENDS
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

PRT8:   RST     RSTEXP          ; EVALUATE THE EXPR
        PUSH    BC
        CALL    PRTNUM          ; PRINT THE VALUE  ;* Print value of expression
        POP     BC
        JR      PRT4            ; Next value [not another PRINT THE VALUE]

; ***************************************************************
; *
; *  *** GOSUB *** & *** RETURN ***
; *
; * 'GOSUB EXPR;' OR 'GOSUB EXPR(CR)' IS LIKE THE 'GOTO' COMMAND,
; * EXCEPT THAT THE CURRENT TEXT POINTER, STACK POINTER ETC. ARE SAVED
; * SO THAT EXECUTION CAN BE CONTINUED AFTER THE SUBROUTINE 'RETURN'.
; * IN ORDER THAT 'GOSUB' CAN BE NESTED (AND EVEN RECURSIVE), THE SAVE
; * AREA MUST BE STACKED.  THE STACK POINTER IS SAVED IN 'STKGOS'.  THE
; * OLD 'STKGOS' IS SAVED IN THE STACK.  IF WE ARE IN THE MAIN ROUTINE,
; * 'STKGOS' IS ZERO (THIS WAS DONE BY THE "MAIN" SECTION OF CODE).
; * BUT WE STILL SAVE IT AS A FLAG FOR NO FURTHER 'RETURN'S.
; *
; * 'RETURN(CR)' UNDOES EVERYTHING THAT 'GOSUB' DID, AND THUS RETURN THE
; * EXECUTION TO THE COMMAND AFTER THE MOST RECENT 'GOSUB'.  IF 'STKDOS'
; * IS ZERO, IT INDICATES THAT WE NEVER HAD A 'GOSUB' AND IS THUS AN
; * ERROR
;
GOSUB:  CALL    PUSHA           ; SAVE THE CURRENT "FOR"  ;* Save current "FOR" params
        RST     RSTEXP          ; PARAMETERS  ;* Evaluate expression
        PUSH    DE              ; AND TEXT POINTER  ;* Save text pointer
        CALL    FNDLN           ; FIND THE TARGET LINE  ;* Find target line
        JP      NZ,AHOW         ; NOT THERE.  SAY "HOW?"  ;* Not present; 'HOW?'
        LD      HL,(CURRNT)     ; SAVE OLD  ;* Save everything
        PUSH    HL              ; 'CURRENT' OLD 'STKGOS'
        LD      HL,(STKGOS)
        PUSH    HL
        LD      HL,$0000        ; AND LOAD NEW ONES
        LD      (LOPVAR),HL    ;* And load it up
        ADD     HL,SP
        LD      (STKGOS),HL
        JP      RUNTSL          ; THEN RUN THAT LINE

RETURN: LD      HL,(STKGOS)     ; OLD STACK POINTER    ;* Old stack pointer
        LD      A,H             ; 0 MEANS NOT EXIST
        OR      L
        JP      Z,QWHAT         ; SO, WE SAY: "WHAT?"  ;* RETURN with no GOSUB
        LD      SP,HL           ; ELSE, RESTORE IT  ;* Restore old SP
        POP     HL
        LD      (STKGOS),HL     ; AND THE OLD 'STKGOS'  ;* And old STKGOS
        POP     HL
        LD      (CURRNT),HL     ; AND THE OLD 'CURRNT'  ;* And old CURRNT
        POP     DE             ;* Get old text pointer
        CALL    POPA           ;* Restore old "FOR" params
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; *******************************************
; *
; * *** FOR *** & NEXT ***
; *
; * 'FOR' HAS TWO FORMS: 'FOR VAR=EXP1 TO EXP2 STEP EXP3' AND
; * 'FOR VAR=EXP1 TO EXP2'.  THE SECOND FORM MEANS THE SAME THING
; * AS THE FIRST FORM WITH EXP3=1, (I.E. WITH A STEP OF +1)  TBI
; * WILL FIND THE VARIABLE VAR. AND SET ITS VALUE TO THE CURRENT
; * VALUE OF EXP1.  IT ALSO EVALUATES EXP2 AND EXP3 AND SAVES ALL
; * THESE TOGETHER WITH THE TEXT POINTER ETC. IN THE 'FOR' SAVE AREA
; * WHICH CONSISTS OF 'LOPVAR', 'LOPINC', 'LOPLMT', 'LOPLN', AND 'LOPPT'.
; * IF THERE IS ALREADY SOMETHING IN THE SAVE AREA (INDICATED BY A
; * NON-ZERO 'LOPVAR'), THEN THE OLD SAVE AREA IS SAVED IN THE STACK
; * BEFORE THE NEW ONE OVERWRITES IT.  TBI WILL THEN DIG IN THE STACK
; * AND FIND OUT IF THIS SAME VARIABLE WAS USED IN ANOTHER CURRENTLY
; * ACTIVE 'FOR' LOOP.  IF THAT IS THE CASE, THEN THE OLD 'FOR' LOOP IS
; * DEACTIVATED.  (PURGED FROM THE STACK..)
; *
; * 'NEXT VAR' SERVES AS THE LOGICAL (NOT NECESSARILY PHYSICAL) END OF
; * THE 'FOR' LOOP.  THE CONTROL VARIABLE VAR. IS CHECKED WITH THE
; * 'LOPVAR'.  IF THEY ARE NOT THE SAME, TBI DIGS IN THE STACK TO FIND
; * THE RIGHT ONE AND PURGES ALL THOSE THAT DID NOT MATCH.  EITHER WAY,
; * TBI THEN ADDS THE 'STEP' TO THAT VARIABLE AND CHECKS THE RESULT WITH
; * THE LIMIT.  IF IT IS WITHIN THE LIMIT, CONTROL LOOPS BACK TO THE
; * COMMAND FOLLOWING THE 'FOR'.  IF OUTSIDE THE LIMIT, THE SAVE AREA IS
; * PURGED AND EXECUTION CONTINUES.
;
FOR:    CALL    PUSHA           ; SAVE THE OLD SAVE AREA  ;* Save old "FOR" params
        CALL    SETVAL          ; SET THE CONTROL VAR.  ;* Set control VRBL
        DEC     HL              ; HL IS ITS ADDRESS
        LD      (LOPVAR),HL     ; SAVE THAT
        TSTCC   $77,FR1         ; TO? - LOOK FOR WORD "TO"  ;* "TO" (don't need one)
        RST     RSTEXP          ; EVALUATE THE LIMIT
FR1:    LD      (LOPLMT),HL     ; SAVE THAT  ;* Save limit
        LD      HL,$0001       ;* Preset step of 1
        TSTCC   $75,FR2         ; STEP?  ;* "STEP" (don't need one), Jump if no match
        RST     RSTEXP         ;* Evaluate expression
FR2:    LD      (LOPINC),HL     ; SAVE THAT TOO  ;* Save increment
        LD      HL,(CURRNT)     ; SAVE CURRENT LINE #
        LD      (LOPLN),HL      ; AND TEXT POINTER  ;* Save current line number
        EX      DE,HL
        LD      (LOPPT),HL     ;* And current text pointer
        LD      BC,$000A        ; DIG INTO STACK TO  ;* Dig into stack to find
        LD      HL,(LOPVAR)     ; FIND 'LOPVAR'  ;*  LOPVAR from last
        EX      DE,HL
        LD      H,B
        LD      L,B             ; HL=0 NOW  ;* HL = 0
        ADD     HL,SP           ; HERE IS THE STACK
        JR      FR4

FR3:    ADD     HL,BC           ; EACH LEVEL IS 10 DEEP  ;* Each level is 10 deeper
FR4:    LD      A,(HL)          ; GET THAT OLD 'LOPVAR'  ;* Get old LOPVAR
        INC     HL
        OR      (HL)
        JR      Z,FR5           ; 0 SAYS NO MORE IN IT  ;* Jp if no more
        LD      A,(HL)
        DEC     HL
        CP      D               ; SAME AS THIS ONE?  ;* Same as this one?
        JR      NZ,FR3
        LD      A,(HL)          ; THE OTHER HALF?  ;* Other half also?
        XOR     E
        JR      NZ,FR3
        EX      DE,HL           ; YES, FOUND ONE  ;* Yes, found one
        LD      H,A
        LD      L,A
        ADD     HL,SP           ; TRY TO MOVE SP  ;* Try to move SP
        LD      B,H
        LD      C,L
        LD      HL,$000A
        ADD     HL,DE
        CALL    MVDOWN          ; AND PURGE 10 WORDS  ;* Purge 10 words
        LD      SP,HL           ; IN THE STACK  ;* In the stack
FR5:    LD      HL,(LOPPT)      ; JOB DONE, RESTORE DE  ;* Job done
        EX      DE,HL
        RST     RSTFIN          ; AND CONTINUE  ;* cr. or ; otherwise, WHAT?

NEXT:   CALL    TSTV            ; GET ADDRESS OF VAR.  ;* Get adrs. of VRBL
        JP      C,QWHAT         ; NO VARIABLE, "WHAT?"  ;* None, 'WHAT?'
        LD      (VARNXT),HL     ; YES, SAVE IT  ;* Save its address
NXT1:   PUSH    DE              ; SAVE TEXT POINTER  ;* Save text pointer
        EX      DE,HL
        LD      HL,(LOPVAR)     ; GET VAR. IN 'FOR'  ;* Get VRBL in FOR
        LD      A,H
        OR      L               ; 0 SAYS NEVER HAD ONE
        JP      Z,AWHAT         ; SO WE ASK: "WHAT?"  ;* Never had one
        CALL    COMP            ; ELSE WE CHECK THEM  ;* Check them for match
        JR      Z,NXT2          ; OK, THEY AGREE  ;* Jp if agree
        POP     DE              ; NO, LET'S SEE  ;* No agree, Purge current
        CALL    POPA            ; PURGE CURRENT LOOP  ;* loop and pop one level
        LD      HL,(VARNXT)     ; AND POP ONE LEVEL
        JR      NXT1            ; GO CHECK AGAIN  ;* Try again

NXT2:   EX      DE,HL           ; COME HERE WHEN AGREED  ;* ;Get value of VRBL to DE
        CALL    LDE             ; DE=VALUE OF VAR. [load from TeXT if necessary]
        LD      L,A
        INC     DE
        CALL    LDE             ; do LD A,(DE) [from TeXT if necessary]
        LD      H,A
        EX      DE,HL
        LD      HL,(LOPINC)    ;* Get increment
        PUSH    HL
        LD      A,H
        XOR     D               ; S=SIGN OF DIFFER
        LD      A,D             ; A=SIGN OF DE
        ADD     HL,DE           ; ADD ONE STEP  ;* Add one step
        JP      M,NXT3          ; CANNOT OVERFLOW
        XOR     H               ; MAY OVERFLOW
        JP      M,NXT5          ; AND IT DID
NXT3:   EX      DE,HL
        LD      HL,(LOPVAR)     ; PUT IT BACK
        LD      A,E
        CALL    STHL            ; STore A by HL [interlaced into TeXT if necessary]
        INC     HL
        LD      A,D
        CALL    STHL            ; STore A by HL [interlaced into TeXT if necessary]
        LD      HL,(LOPLMT)     ; HL=LIMIT
        POP     AF              ; OLD HL
        OR      A               ; EXAMINE SIGN BIT
        JP      P,NXT4          ; IF POS SKIP EX     DE,HL  ;* Step > 0
        EX      DE,HL          ;* Step < 0
NXT4:   CALL    CKHLDE          ; COMPARE WITH LIMIT  ;* Compare with limit
        POP     DE              ; RESTORE TEST POINTER  ;* Restore text pointer
        JR      C,NXT6          ; OUTSIDE LIMIT  ;* Outside limit
        LD      HL,(LOPLN)      ; WITHIN LIMIT, GO  ;* Within limit
        LD      (CURRNT),HL     ; BACK TO THE SAVED  ;* Put LOPLN in CURRNT
        LD      HL,(LOPPT)      ; 'CURRNT' AND TEXT  ;*  and LOPPT
        EX      DE,HL           ; POINTER
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; RESTO LINKS IN HERE
NXT5:   POP     HL              ; OVERFLOW , PURGE
        POP     DE              ; GARBAGE IN STACK
NXT6:   CALL    POPA            ; PURGE THIS LOOP
        RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

; IF AND REM routines
;
REM:    LD      HL,$0000       ;* Make it false
        JR      IFREM

;* . Comment line
IFF:    RST     RSTEXP         ;* Evaluate expression
IFREM:  LD      A,H
        OR      L
        JP      NZ,RUNSML      ;* Jp if true
        CALL    FND2           ;* Otherwise skip rest of line
        JP      NC,RUNTSL      ;* And run next one
        JP      RSTART

; *********************************************************
; *
; * *** IF *** INPUT *** & LET (& DEFLT) ****
; *
; * 'IF' IS FOLLOWED BY AN EXPR. AS A CONDITION AND ONE OR MORE COMMANDS
; * (INCLUDING OTHER 'IF'S) SEPARATED BY SEMI-COLONS.  NOTE THAT THE
; * WORD 'THEN' IS NOT USED.  TBI EVALUATES THE EXPR. IF IT IS NON-ZERO,
; * EXECUTION CONTINUES.  IF THE EXPR. IS ZERO, THE COMMANDS THAT
; * FOLLOW ARE IGNORED AND EXECUTION CONTINUES AT THE NEXT LINE.
; *
; * 'INPUT' COMMAND IS LIKE THE 'PRINT' COMMAND, AND IS FOLLOWED BY A
; * LIST OF ITEMS.  IF THE ITEM IS A STRING IN A SINGLE OR DOUBLE QUOTES,
; * OR IS AN UP-ARROW, IT HAS THE SAME EFFECT AS IN 'PRINT'.  IF AN ITEM
; * IS A VARIABLE, THIS VARIABLE NAME IS PRINTED OUT FOLLOWED BY A
; * COLON.  THEN TBI WAITS FOR AN EXPR. TO BE TYPED IN.  THE VARIABLE IS
; * THEN SET TO THE VALUE OF THIS EXPR.  IF THE VARIABLE IS PROCEDED BY
; * A STRING (AGAIN IN SINGLE OR DOUBLE QUOTES), THE STRING WILL BE
; * PRINTED FOLLOWED BY A COLON.  TBI THEN WAITS FOR INPUT EXPR.   AND
; * SETS THE VARIABLE TO THE VALUE OF THE EXPR.
; *
; * IF THE INPUT EXPR. IS INVALID, TBI WILL PRINT "WHAT?", "HOW?", OR
; * "SORRY" AND REPRINT THE PROMPT AND REDO THE INPUT.  THE EXECUTION
; * WILL NOT TERMINATE UNLESS YOU TYPE CONTROL-C.  THIS IS HANDLED IN
; * 'INPERR'.
;
INPERR: LD      HL,(STKINP)     ; *** INPERR ***
        LD      SP,HL           ; RESTORE OLD SP
        POP     HL              ; AND OLD 'CURRNT'
        LD      (CURRNT),HL
        POP     DE              ; AND OLD TEXT POINTER
        POP     DE              ; REDO INPUT
INPUT:  PUSH    DE              ; SAVE IN CASE OF ERROR
        CALL    QTSTG           ; IS NEXT ITEM A STRING?
        JR      INP4            ; NO

INP0:   CALL    TSTV            ; YES, BUT FOLLOWED BY A  ;* Get adrs. of VRBL
        JR      C,INP2          ; M6IVARIABLE? NO.
INP1:   CALL    INP6
        LD      DE,BUFFER       ; POINTS TO BUFFER
        RST     RSTEXP          ; EVALUATE INPUT
        POP     DE              ; OK, GET OLD HL
        EX      DE,HL
        LD      A,E            ;* Save value in VRBL
        CALL    STHL            ; STore A by HL [interlaced into TeXT if necessary]
        INC     HL
        LD      A,D
        CALL    STHL            ; STore A by HL [interlaced into TeXT if necessary]
        POP     HL              ; GET OLD 'CURRNT'
        LD      (CURRNT),HL
        POP     DE              ; AND OLD TEXT POINTER
INP2:   POP     AF              ; PURGE JUNK IN STACK
        TSTCC   COMMA,INP3      ; IS NEXT CH. ','?  ;* Jump if no match
        JR      INPUT           ; YES, MORE ITEMS.

INP3:   RST     RSTFIN         ;* cr. or ; otherwise, WHAT?

INP4:   PUSH    DE              ; SAVE FOR 'PRTSTG'
        CALL    TSTV            ; MUST BE VARIABLE NOT  ;* Get adrs. of VRBL
        JR      NC,INP5        ;* OK [became JP  C,QWHAT in ab]
        JP      QWHAT           ; "WHAT?" IT IS NOT?

INP5:   LD      B,E
        POP     DE
        CALL    PRTCHS          ; PRINT THOSE AS PROMPT
        JR      INP1            ; YES, INPUT VARIABLE

INP6:   POP     BC              ; RETURN ADDRESS
        PUSH    DE              ; SAVE TEXT POINTER  ;* Save in case of error
        EX      DE,HL
        LD      HL,(CURRNT)     ; ALSO SAVE 'CURRNT'
        PUSH    HL
        LD      HL,INPUT        ; A NEGATIVE NUMBER
        LD      (CURRNT),HL     ; AS A FLAG
        LD      HL,$0000        ; SAVE SP TOO
        ADD     HL,SP
        LD      (STKINP),HL
        PUSH    DE              ; OLD HL
        PUSH    BC
        LD      A,' '          ;* Space after VRBL
        JP      GETLN           ; AND GET A LINE

ENDCHK: LD      A,(DE)         ;* End of list 1 [or DEFLT: ??]
        CP      CR             ;* Empty link is OK
        JR      Z,INP3
        JP      QWHAT          ;* Else 'WHAT?'

; *********************************************
; *
; * *** EXPR ***
; *
; * 'EXPR' EVALUATES ARITHMETICAL OR LOGICAL EXPRESSIONS.
; * <EXPR>::=<EXPR1>
; *           <EXPR1><REL.OP><EXPR1>
; * WHERE <REL.OP> IS ONE OF THE OPERATORS IN TAB6 AND THE RESULT
; * OF THESE OPERATIONS IS 1 IF TRUE AND 0 IF FALSE.
; *
; * <EXPR1>::=(+ OR -)<EXPR2>(+ OR -<EXPR2>)(...)
; * WHERE () ARE OPTIONAL AND (...) ARE OPTIONAL REPEATS.
; *
; * <EXPR2>::=<<EXPR3>(<* OR /><EXPR3>)(...)
; *
; * <EXPR3>::=<VARIABLE>
; *            <FUNCTION>
; *            (<EXPR>)
; *
; * <EXPR> IS RECURSIVE SO THAT VARIABLE '@' CAN HAVE AN <EXPR>
; * AS INDEX, FUNCTIONS CAN HAVE AN <EXPR> AS ARGUMENTS, AND
; * <EXPR3> CAN BE AN <EXPR> IN PARENTHESES.
;
EXPR:   CALL    EXPR1           ; *** EXPR ***
        PUSH    HL              ; SAVE <EXPR1> VALUE
        LD      HL,TAB6 - 1     ; LOOKUP REL.OP.
        JP      EXEC            ; GO DO IT.

XPR1:   CALL    XPR8            ; REL.OP. ">="
        RET     C               ; NO, RETURN HL=0
        LD      L,A             ; YES, RETURN HL=1
        RET

XPR2:   CALL    XPR8            ; REL.OP. "#"
        RET     Z               ; FALSE, RETURN HL=0
        LD      L,A             ; TRUE, RETURN HL=1
        RET

XPR3:   CALL    XPR8            ; REL.OP. ">"
        RET     Z               ; FALSE
        RET     C
        LD      L,A             ; TRUE, RETURN HL=1
        RET

XPR4:   CALL    XPR8            ; REL.OP "<="
        LD      L,A             ; SET HL=1
        RET     Z               ; REL. TRUE, RETURN
        RET     C
        LD      L,H             ; ELSE SET HL=0
        RET

XPR5:   CALL    XPR8            ; REL.OP. "="
        RET     NZ              ; FALSE, RETURN HL=0
        LD      L,A             ; ELSE SET HL=1
        RET

XPR6:   CALL    XPR8            ; REL.OP. "<"
        RET     NC              ; FALSE, RETURN HL=0
        LD      L,A             ; ELSE SET HL=1
        RET

XPR7:   POP     HL              ; NOT REL.OP.  ;* - end of list 3
        RET                     ; RETURN HL=<EXPR1>

XPR8:   LD      A,C             ; SUBROUTINE FOR ALL
        POP     HL              ; REL.OP.'S
        POP     BC
        PUSH    HL              ; REVERSE TOP OF STACK
        PUSH    BC
        LD      C,A
        CALL    EXPR1           ; SET 2ND <EXPR1>
        EX      DE,HL           ; VALUE IN DE NOW
        EX      (SP),HL         ; 1ST <EXPR1> IN HL
        CALL    CKHLDE          ; COMPARE 1ST WITH 2ND
        POP     DE              ; RESTORE TEXT POINTER
        LD      HL,$0000        ; SET HL=0, A=1
        LD      A,$01
        RET

EXPR1:  TSTC    '-',XP11        ; NEGATIVE SIGN?  ;* Jump if no match
        LD      HL,$0000        ; YES, FAKE "0-"
        JR      XP16            ; TREAT LIKE SUBTRACT  ;* Fake "0-x"

XP11:   TSTC    '+',XP12        ; POSITIVE SIGN?  IGNORE  ;* Ignore leading +
XP12:   CALL    EXPR2           ; 1ST <EXPR2>
XP13:   TSTC    '+',XP15        ; ADD? [NOT leading +]  ;* Jump if no match
        PUSH    HL              ; YES, SAVE VALUE
        CALL    EXPR2           ; GET 2ND <EXPR2>
XP14:   EX      DE,HL           ; 2ND IN DE
        EX      (SP),HL         ; 1ST IN HL
        LD      A,H             ; COMPARE SIGN
        XOR     D
        LD      A,D
        ADD     HL,DE
        POP     DE              ; RESTORE TEST POINTER
        JP      M,XP13          ; 1ST 2ND SIGN DIFFER  ;* Jp if signs different
        XOR     H               ; 1ST 2ND SIGN EQUAL  ;* Signs alike
        JP      P,XP13          ; SO IS RESULT
        JP      QHOW            ; ELSE WE HAVE OVERFLOWN

XP15:   TSTC    '-',XPR9        ; SUBTRACT?  ;* Jump if no match
XP16:   PUSH    HL              ; YES, SAVE 1ST <EXPR2>
        CALL    EXPR2           ; GET 2ND <EXPR2>
        CALL    CHGSGN          ; NEGATE
        JR      XP14            ; AND ADD THEM

EXPR2:  CALL    EXPR3           ; GET 1ST <EXPR3>
XP21:   TSTCC   $62,XP24        ; MULTIPLY?  ;* Jump if no match
        PUSH    HL              ; YES, SAVE 1ST
        CALL    EXPR3           ; AND GET 2ND <EXPR3>
        LD      B,$00           ; CLEAR B FOR SIGN
        CALL    CHKSGN          ; CHECK SIGN
        EX      (SP),HL         ; 1ST IN HL
        CALL    CHKSGN          ; CHECK SIGN OF 1ST
        EX      DE,HL          ;* 2nd in DE
        EX      (SP),HL        ;* Get back 1st
        LD      A,H             ; IS HL > 255?
        OR      A
        JR      Z,XP22          ; NO  ;* Jp if HL <255
        LD      A,D             ; YES, HOW ABOUT DE
        OR      D
        EX      DE,HL           ; PUT SMALLER IN DE
        JP      NZ,AHOW         ; ALSO >, WILL OVERFLOW ;* Jp if DE >255 (will overflow)
XP22:   LD      A,L             ; THIS IS DUMB
        LD      HL,$0000        ; CLEAR RESULT
        OR      A               ; ADD AND COUNT
        JR      Z,XP25         ;* Done
XP23:   ADD     HL,DE
        JP      C,AHOW          ; OVERFLOW
        DEC     A
        JR      NZ,XP23        ;* Continue multiply
        JR      XP25            ; FINISHED

XP24:   TSTCC   $63,XPR9        ; DIVIDE?  ;* Jump if no match
        PUSH    HL              ; YES, SAVE 1ST <EXPR3>
        CALL    EXPR3           ; AND GET 2ND ONE
        LD      B,$00           ; CLEAR B FOR SIGN
        CALL    CHKSGN          ; CHECK SIGN OF 2ND
        EX      (SP),HL         ; GET 1ST IN HL
        CALL    CHKSGN          ; CHECK SIGN OF 1ST
        EX      DE,HL
        EX      (SP),HL
        EX      DE,HL
        LD      A,D             ; DIVIDE BY 0?
        OR      E
        JP      Z,AHOW          ; SAY "HOW?"
        PUSH    BC              ; ELSE, SAVE SIGN
        CALL    DIVIDE          ; USE SUBROUTINE
        POP     DE              ; SIGN STUFF TO DE
        PUSH    BC              ; SAVE DIVIDE RESULT
        BIT     7,D             ; WAS SIGN SET?
        CALL    NZ,CHGSGN       ; YEP - CHANGE
        LD      (REMAIN),HL     ; STUFF IT
        POP     HL              ; RESULT IN HL
        LD      B,D             ; COPY OVER SIGN STUFF
        LD      C,E
XP25:   POP     DE              ; GET TEXT POINTER BACK
        LD      A,H             ; HL MUST BE +
        OR      A
        JP      M,QHOW          ; ELSE IT IS OVERFLOW
        LD      A,B
        OR      A
        CALL    M,CHGSGN        ; CHANGE SIGN IF NEEDED
        JR      XP21            ; LOOK FOR MORE TERMS

EXPR3:  LD      HL,TAB3 - 1     ; FIND FUNCTION IN TAB3
        JP      EXEC            ; AND GO DO IT

NOTF:   CALL    TSTV            ; NO, NOT A FUNCTION  ;* End of list 2
        JR      C,XP32          ; NOR A VARIABLE  ;* Is it a variable? No
        EX      DE,HL          ;* Yes, a variable
        CALL    LDE             ; do LD A,(DE) [from TeXT if necessary]
        PUSH    AF
        INC     DE
        CALL    LDE             ; do LD A,(DE) [from TeXT if necessary]
        EX      DE,HL
        LD      H,A            ;* Get VRBL value to HL
        POP     AF
        LD      L,A
        RET

XP32:   CALL    TSTNUM          ; OR IS IT A NUMBER?
        LD      A,B             ; # OF DIGIT
        OR      A
        RET     NZ              ; OK
; SINGLE CHAR STRING CONSTANT?
        TSTC    '"',PARN        ; HAVE WE GOT QUOTES?  ;* Get one byte ASCII input
        CALL    LDE             ; NAILED RSTLDE LDE [load from TeXT if necessary]
        LD      L,A             ; FAILED TSTNUM SET H TO ZERO
        INC     DE
        TSTC    '"',XPRO        ; ERROR IF NO TRAILING  ;* Jump if no match
        RET

; *****
; *
;
PARN:   TSTC    '(',XPRO        ; NO DIGIT, MUST BE  ;* Open, Jump if no match
        RST     RSTEXP          ; "(EXPR)"  ;* Evaluate expression
        TSTC    ')',XPRO       ;* Close = Char. to check, Jump if no match
XPR9:   RET

XPRO:   JP      QWHAT           ; ELSE SAY: "WHAT?"

; *** RND(EXOR) ***
;
RND:    RST     RSTPAR         ;* Get value of () or storage adrs
        LD      A,H             ; EXPR MUST BE +
        OR      A
        JP      M,QHOW         ;* Bad if -
        OR      L
        JP      Z,QHOW         ;* or if 0
        PUSH    DE              ; SAVE BOTH
        EX      DE,HL           ; DE = RANGE
        XOR     A
        SYSTEM  RANGED          ; Get Random Number

        LD      L,A
        XOR     A
        SYSTEM  RANGED          ; Get Random Number

        LD      H,A
; HL = RANDOM #
        PUSH    BC
        CALL    DIVIDE          ; RND(N)=MOD(M,N)+1
        POP     BC
        POP     DE
        INC     HL
        RET

; *** ABS(EXPR) ***
;
ABS:    RST     RSTPAR         ;* Get value of () or storage adrs
        DEC     DE
        CALL    CHKSGN          ; CHECK SIGN
        INC     DE
        RET

SIZE:   LD      HL,(TXTUNF)     ; *** SIZE ***
        PUSH    DE              ; GET THE NUMBER OF
        EX      DE,HL           ; FREE BYTES BETWEEN 'TXTUNF'
        LD      HL,DFTLMT       ; AND 'TXTLMT' {INROM note: $3FFF [in ROM]}
        AND     A
        SBC     HL,DE
        POP     DE
        RET

; FUNCTION TO SENSE DIAL VALUE
;
GETPOT: LD      A,$1B
        CALL    CHKRNG          ; GET DATA
        CPL
        SUB     $80
        LD      L,A
; FALL INTO...
; SIGN EXTEND SUBROUTINE
SGNEXT: LD      H,$00
        LD      A,L
        AND     A
        RET     P
        DEC     H
        RET

; FUNCTION TO SENSE STATE OF TRIGGER
;
GETTRG: CALL    CHKRN1          ; do CHecK RaNge is 1-4
        AND     $10
        RET     Z
        INC     L
        RET

; FUNCTIONS TO RETURN JOYSTICK VALUE
; THESE FUNCTIONS RETURN EITHER +1, 0, OR -1, DEPENDING
; ON JOYSTICK STATE
;
GETJX:  CALL    CHKRN1          ; PARM IN RANGE?
        RRCA
        RRCA
        RRCA
        JR      C,GETJY3
        RRCA
        JR      C,GETJY1
        RET

; ENTRY FOR Y JOYSTICK VALUE
GETJY:  CALL    CHKRN1          ; do CHecK RaNge is 1-4
        RRCA
        JR      NC,GETJY2
GETJY1: INC     HL
        RET

GETJY2: RRCA
        RET     NC
GETJY3: DEC     HL
        RET

; SUBROUTINE TO GET PARAMETER BETWEEN 1 AND 4
;
CHKRN1: LD      A,$0F
CHKRNG: PUSH    BC
        PUSH    AF
        RST     RSTPAR         ;* Get value of () or storage adrs
        POP     AF
        ADD     A,L
        LD      C,A
        IN      A,(C)
        POP     BC
        LD      HL,$0000
        RET

; **********************************************
; * *** DIVIDE *** SUBDE *** CHKSGN *** CHGSGN *** & CKHLDE ***
; *
; * 'DIVIDE' DIVIDES HL BY DE, RESULT IN BC, REMAINDER IN HL
; *
; * 'SUBDE' SUBTRACTS DE FROM HL
; *
; * 'CHKSGN' CHECKS SIGN OF HL.  IF +, NO CHANGE.  IF -, CHANGE SIGN
; * AND FLIP SIGN OF B.
; *
; * 'CHKSGN' CHANGES SIGN OF HL AND B UNCONDITIONALLY.
; *
; * 'CKHLDE' CHECKS SIGN OF HL AND DE.  IF DIFFERENT, HL AND DE ARE
; * INTERCHANGED.  IF SAME SIGN, NOT INTERCHANGED.  EITHER CASE, HL DE
; * ARE THEN COMPARED TO SET THE FLAGS.
;
DIVIDE: PUSH    HL              ; *** DIVIDE ***
        LD      L,H             ; DIVIDE H BY DE
        LD      H,$00
        CALL    DV1
        LD      B,C             ; SAVE RESULT IN B
        LD      A,L             ; (REMAINDER + L)/DE
        POP     HL
        LD      H,A
DV1:    LD      C,$FF           ; RESULT IN C [initialize to -1]
DV2:    INC     C               ; DUMB ROUTINE
        AND     A
        SBC     HL,DE
        JR      NC,DV2
        ADD     HL,DE
        RET

CHKSGN: LD      A,H             ; *** CHKSGN ***  ;* Check sign of HL
        OR      A               ; CHECK SIGN OF HL
        RET     P               ; IF -, CHANGE SIGN  ;* Leave if +

CHGSGN: LD      A,H             ; *** CHGSGN ***  ;* Change sign of HL
        OR      L
        RET     Z              ;* +0 stays the same
        LD      A,H            ;* Change sign
        PUSH    AF
        CPL                     ; CHANGE SIGN OF HL
        LD      H,A
        LD      A,L
        CPL
        LD      L,A
        INC     HL
        POP     AF
        XOR     H
        JP      P,QHOW
        LD      A,B             ; AND ALSO FLIP B  ;* Also flip sign of B
        XOR     $80
        LD      B,A
        RET

CKHLDE: LD      A,H             ; *** CKHLDE ***
        XOR     D               ; SAME SIGN?
        JP      P,CK1           ; YES, COMPARE  ;* Jp if same sign
        EX      DE,HL           ; NO, XCH AND COMPARE  ;* Exchange
CK1:    CALL    COMP           ;* Compare
        RET

;* COMPare HL and DE
;* Z if HL = DE
;* C if HL < DE
COMP:   LD      A,H             ; *** COMP ***
        CP      D               ; COMPARE HL WITH DE
        RET     NZ              ; RETURN CORRECT C AND
        LD      A,L             ; ZFLAGS
        CP      E               ; BUT OLD A IS LOST
        RET

; ***************************************************
; *
; * *** SETVAL *** FIN *** ENDCHK *** & ERROR (& FRIENDS)***
; *
; * 'SETVAL' EXPECTS A VARIABLE, FOLLOWED BY AN EQUAL SIGN AND THEN AN
; * EXPR.  IT EVALUATES THE EXPR. AND SETS THE VARIABLE TO THAT VALUE.
; *
; * 'FIN' CHECKS THE END OF A COMMAND.  IF IT ENDED WITH ";", EXECUTION
; * CONTINUES.  IF IT ENDED WITH A CR, IT FINDS THE NEXT LINE AND
; * CONTINUES FROM THERE.
; *
; * 'ENDCHK' CHECKS IF A COMMAND IS ENDED WITH CR.  THIS IS REQUIRED IN
; * CERTAIN COMMANDS. (GOTO, RETURN, AND STOP ETC.) [up with 'INPUT' ??]
; *
; * 'ERROR' PRINTS THE STRING POINTED BY DE (AND ENDS WITH CR). IT THEN
; * PRINTS THE LINE POINTED BY 'CURRNT' WITH A "?" INSERTED AT WHERE THE
; * OLD TEXT POINTER (SHOULD BE ON TOP OF THE STACK) POINTS TO.
; * EXECUTION OF TB IS STOPPED AND TBI IS RESTARTED.  HOWEVER, IF
; * 'CURRNT'=> ZERO (INDICATING A DIRECT COMMAND), THE DIRECT COMMAND
; * IS NOT PRINTED. AND IF 'CURRNT'=>NEGATIVE # (INDICATING 'INPUT'
; * COMMAND, THE INPUT LINE IS NOT PRINTED AND EXECUTION IS NOT
; * TERMINATED BUT CONTINUED AT 'INPERR'.
; *
; * RELATED TO 'ERROR' ARE THE FOLLOWING: 'QWHAT' SAVES TEXT POINTED IN
; * STACK AND GETS MESSAGE "WHAT?".  'AWHAT' JUST GETS MESSAGE "WHAT?"
; * AND JUMPS TO 'ERROR'.  'QSORRY' AND 'ASORRY' DO SAME KIND OF THING.
; * 'QHOW' AND 'AHOW' IN THE ZERO PAGE SECTION ALSO DO THIS.
;
SETVAL: CALL    TSTVFF          ; *** SETVAL ***
        TSTC    '=',QWHAT       ; "WHAT?" NO VARIABLE  ;* Jump if no match
SETV1:  PUSH    HL              ; SAVE ADDRESS OF VAR.
        RST     RSTEXP          ; EVALUATE EXPR.
        LD      B,H
        LD      C,L            ;* Value now in BC
        POP     HL             ;* Get address
        PUSH    AF
        LD      A,C
        CALL    STHL           ;* Place into VRBL [interlaced into TeXT if necessary]
        INC     HL
        LD      A,B
        CALL    STHL            ; STore A by HL (interlaced into TeXT if necessary)
        POP     AF
        RET

FINISH: CALL    FIN             ; CHECK END OF COMMAND  ;* RST30 after POP AF
        JR      QWHAT           ; PRINT "WHAT?" IF WRONG

FIN:    TSTCC   $3B,FIN1        ; *** FIN ***  ;* Semicolon, Jump if no match
        POP     AF              ; ";", PURGE RET ADDR.
        JP      RUNSML          ; CONTINUE SAME LINE

FIN1:   TSTCC   CR,FNDX         ; NOT ";", IS IT CR?  ;* $0D, Jump if no match
        POP     AF              ; PURGE RETURN ADDRESS
        JP      RUNX1

; *** IGNBLK ***  ;* RST20 [not RST#0]
IGNBLK: CALL    LDE             ; do LD A,(DE) [from TeXT if necessary]
        CP      ' '             ; IGNORE BLANKS $20
        RET     NZ              ; IN TEXT (WHERE DE->)
        INC     DE              ; AND RETURN THE FIRST
        JR      IGNBLK          ; NON-BLANK CHAR. IN A

QWHAT:  PUSH    DE              ; *** QWHAT ***
AWHAT:  LD      DE,WHAT         ; *** AWHAT ***
ERROR:  CALL    CRLF            ; *** ERROR ***
        CALL    PRTSTG          ; PRINT ERROR MESSAGE
        LD      HL,(CURRNT)     ; GET CURRENT LINE #  ;* Current line pointer
        PUSH    HL             ;* Save it
        EX      DE,HL           ; CHECK THE VALUE
        CALL    LDE            ;* Get character in text
        LD      H,A
        INC     DE
        CALL    LDE             ; do LD A,(DE) [from TeXT if necessary]
        OR      H
        EX      DE,HL
        POP     DE             ;* Set DE to line #
        JP      Z,TELL          ; IF ZERO, JUST RESTART  ;* If 0, just restart
        EX      DE,HL           ; IF NEGATIVE  ;* Get first digit
        CALL    LDE             ; do LD A,(DE) [from TeXT if necessary]
        EX      DE,HL
        OR      A
        JP      M,INPERR        ; REDO INPUT  ;* If negative, redo input
        CALL    PRTLN           ; ELSE PRINT THE LINE number then Space
        POP     BC              ; HL=ERROR ADDR
        LD      B,C
        CALL    PRTCHS
        LD      A,'?'
        RST     RSTOUT          ; Output $3F Question Mark
        CALL    PRTSTG          ; LINE
        JP      TELL            ; THEN RESTART

QSORRY: PUSH    DE              ; *** QSORRY ***
ASORRY: LD      DE,SORRY        ; *** ASORRY ***
        JR      ERROR

; ******************************************
; *
; * *** FNDLN (& FRIENDS) ***
; *
; * 'FNDLN' FINDS A LINE WITH A GIVEN LINE # (IN HL) IN THE TEXT SAVE
; * AREA.  DE IS USED AS THE TEXT POINTER.  IF THE LINE IS FOUND, DE
; * WILL POINT TO THE BEGINNING OF THAT LINE (I.E., THE LOW BYTE OF THE
; * LINE #), AND FLAGS ARE NC & Z.  IF THAT LINE IS NOT THERE AND A LINE
; * WITH A HIGHER LINE # IS FOUND, DE POINTS TO THERE AND FLAGS ARE NC &
; * NZ.  IF WE REACHED THE END OF TEXT SAVE AREA AND CANNOT FIND THE
; * LINE, FLAGS ARE C & NZ.  'FNDLN' WILL INITIALIZE DE TO THE BEGINNING
; * OF THE TEXT SAVE AREA TO START THE SEARCH.  SOME OTHER ENTRIES OF
; * THIS ROUTINE WILL NOT INITIALIZE DE AND DO THE SEARCH.  'FNDLP'
; * WILL START WITH DE AND SEARCH FOR THE LINE #.  'FNDNXT' WILL BUMP DE
; * BY 2, FIND A CR AND THEN START SEARCH.  'FNDSKP' USES DE TO FIND A
; * CR, AND THEN STARTS SEARCH.
;
FNDLN:  LD      A,H             ; *** FNDLN ***
        OR      A               ; CHECK SIGN OF HL
        JP      M,QHOW          ; IT CANNOT BE -
        LD      DE,TXT          ; INIT. TEXT POINTER {INROM: $3000 [in ROM]}
FNDLP:  INC     DE              ; IS EDT MARK?
        CALL    LDE             ; do LD A,(DE) [from TeXT if necessary]
        LD      C,A
        DEC     DE
        ADD     A,A
        RET     C
        CALL    LDE             ; C,NZ PASSED END [load from TeXT if necessary]
        SUB     L               ; WE DID NOT, GET BYTE 1
        LD      B,A             ; IS THIS THE LINE?
        INC     DE              ; COMPARE LOW ORDER
        LD      A,C             ; GET BYTE 2
        SBC     A,H             ; COMPARE HIGH ORDER
        JR      C,FND1          ; NO, NOT THERE YET
        DEC     DE              ; ELSE WE EITHER FOUND
        OR      B               ; IT, OR IT IS NOT THERE
FNDX    RET                     ; NC,Z: FOUND; NC,NZ: NO

FNDNXT: INC     DE              ; FIND NEXT LINE
FND1:   INC     DE              ; JUST PASSED BYTE
FND2:   CALL    LDE            ;* Try to find cr [load from TeXT if necessary]
        CP      CR              ; HIT A CR YET?
        JR      NZ,FND1         ; NO SIR EEE
        INC     DE
        JR      FNDLP           ; REENTER FIND LOOP

; *** TSTV ***
;* Get VRBL storage address
;
TSTV:   RST     RSTIGN         ;* Get next non-blank from (DE)
        CP      '%'             ; PEEK-POKE?
        JR      Z,TSTV1
        SUB     '@'             ; TEST VARIABLE
        RET     C               ; C: NOT A VARIABLE
        JR      NZ,TSTV2        ; NOT "@" ARRAY
; [ab calls as GRAB AND VERIFY SUBSCRIPT routine here ??]
        INC     DE              ; SKIP DA NAME
        RST     RSTPAR          ; GET THE PARM  ;* Get value of () or storage adrs
        ADD     HL,HL           ; CONVERTETH TO BYTES
        JP      C,QHOW          ; REJECT ABSURD VALUES
        PUSH    DE              ; SAVE SCAN PTR
        EX      DE,HL
        CALL    SIZE            ; CHECK FOR VALID SUBSCRIPT
        CALL    COMP            ; do COMPare HL and DE
        JR      C,ASORRY        ; APOLOGIZE FOR RANGE ERR
;
        LD      HL,(TXTUNF)
        DEC     HL
        DEC     HL
        ADD     HL,DE
        POP     DE
        RET

; does %(ADDR) PEEK-POKE CALL here
;
TSTV1:  INC     DE
        RST     RSTPAR          ; GET ADDR  ;* Get value of () or storage adrs
        XOR     A               ; CLEAR CY
        RET                     ; AND GO BACK

TSTV2:  CP      $1B             ; NOT @, IS IT A TO Z
        CCF                     ; IF NOT RETURN C FLAG
        RET     C
        INC     DE              ; IF A THROUGH Z
; IS SECOND CHARACTER ALSO ALPHA?
        LD      L,A             ; SAVE FIRST ONE
        CALL    LDE             ; ZAPPED RSTLDE [?? ab] from TeXT if necessary
        CP      'A'
        JR      C,DEVV4         ; IF NOT IN RANGE A-Z
        CP      'Z' + 1
        JR      NC,DEVV4        ; THEN SEARCH
        PUSH    BC
        PUSH    DE
        LD      H,A             ; SECOND CHAR TO H
        LD      B,PARNUM        ; B - ITERATION CTR
        LD      DE,DEVLST       ; DE - SEARCH TABLE
DEVV1:  LD      A,(DE)          ; GET FIRST ENTRY
        INC     DE
        CP      L
        LD      A,(DE)
        INC     DE
        JR      NZ,DEVV2
        CP      H
        JR      NZ,DEVV2
; MATCH FOUND - FIGURE OUT LOOKUP INDEX
        LD      A,B
        ADD     A,$1A
        LD      L,A
        POP     DE
        INC     DE              ; BUMP CHAR PTR
        JR      DEVV3

; MISMATCH - LOOP BACK IF POSS
DEVV2:  DJNZ    DEVV1
; NOT POSSIBLE - RETURN NOT A VAR
        POP     DE
        POP     BC
        DEC     DE              ; BACKUP TO CHAR START
        SCF                     ; SET CARRY
        RET

DEVV3:  POP     BC
DEVV4:  LD      A,L
        LD      HL,VARBGN - 2
        RLCA
        ADD     A,L
        LD      L,A
        LD      A,$00
        ADC     A,H
        LD      H,A
        RET

; ****************************************
; *
; * *** TSTCH *** TSTNUM ***
; *
; * 'TSTCH' IS USED TO TEST THE NEXT NON-BLANK CHARACTER IN THE TEXT
; * (POINTED BY DE) AGAINST THE CHARACTER THAT FOLLOWS THE CALL.  IF
; * THEY DO NOT MATCH, N BYTES OF CODE WILL BE SKIPPED OVER, WHERE N IS
; * BETWEEN 0 & 255 AND IS STORED IN THE SECOND BYTE FOLLOWING THE CALL
; *
; * 'TSTNUM' IS USED TO CHECK WHETHER THE TEXT (POINTED BY DE) IS A
; * NUMBER.  IF A NUMBER IS FOUND, B WILL BE NON-ZERO AND HL WILL
; * CONTAIN THE VALUE (IN BINARY) OF THE NUMBER, ELSE B AND HL ARE 0.
;
;****************************************
;*      RST8    TSTCH                   *
;****************************************
;
TSTCH:  EX      (SP),HL         ;  *** TSTCH ***  ;* Get (caller+1)
        RST     RSTIGN          ; IGNORE LEADING BLANKS  ;* Get next non-blank from (DE)
        CP      (HL)            ;  AND TEST THE CHARACTER  ;* Same?
        INC     HL              ; COMPARE THE BYTE THAT  ;* Next location
        JR      Z,TCH1          ; FOLLOWS THE CALL INTS.  ;* Match!
        PUSH    BC              ; WITH TEXT (DE->)
        LD      C,(HL)          ;  IF NOT =, ADD THE 2ND  ;* Get # of bytes to skip
        LD      B,$00           ;  BYTE THAT FOLLOWS THE
        ADD     HL,BC           ;  CALL TO THE OLD PC  ;* Increment past
        POP     BC              ;  I.E., DO A RELATIVE
        DEC     DE              ;  JUMP IF NOT =  ;* Stay stuck on non-match
TCH1:   INC     DE              ;  IF =, SKIP THOSE BYTES  ;* Next char.
        INC     HL              ;  AND CONTINUE  ;* Bump past # bytes
        EX      (SP),HL        ;* Put return back on stack
        RET

TSTNUM: LD      HL,$0000        ; *** TSTNUM ***
        LD      B,H             ; TEST IF THE TEXT IS
        RST     RSTIGN          ; A NUMBER  ;* Get next non-blank from (DE)
TNM1:   CP      '0'             ; IF NOT, RETURN 0 IN
        RET     C               ; B AND HL
        CP      ':'             ; IF NUMBERS, CONVERT
        RET     NC              ; TO BINARY IN HL AND
        LD      A,$F0           ; SET B TO # OF DIGITS
        AND     H               ; IF H>255, THERE IS NO
        JR      NZ,QHOW         ; ROOM FOR NEXT DIGIT
        INC     B               ; B COUNTS # OF DIGITS
        PUSH    BC
        LD      B,H             ; HL=10*HL+(NEW DIGIT)
        LD      C,L
        ADD     HL,HL           ; WHERE 10* IS DONE BY
        ADD     HL,HL           ; SHIFT AND ADD
        ADD     HL,BC
        ADD     HL,HL
        CALL    LDE             ; AND (DIGIT) IS FROM [load from TeXT if necessary]
        INC     DE              ; STRIPPING THE ASCII
        AND     $0F             ; CODE
        ADD     A,L
        LD      L,A
        LD      A,$00
        ADC     A,H
        LD      H,A
        POP     BC
        CALL    LDE             ; DO THIS DIGIT AFTER [load from TeXT if necessary]
        JP      P,TNM1          ; DIGIT. S SAYS OVERFLOW
QHOW:   PUSH    DE              ; *** ERROR: "HOW?" ***
AHOW:   LD      DE,HOW
        JP      ERROR

; * *** MVUP *** MVDOWN *** POPA *** AND PUSHA ***
; *
; * 'MVUP' MOVES A BLOCK UP FROM WHERE DE-> TO WHERE BC->
; *       UNTIL DE=HL
; *
; * 'MVDOWN' MOVES A BLOCK DOWN FROM WHERE DE-> TO WHERE HL->
; *       UNTIL DE=BC
; *
; * 'POPA' RESTORES THE 'FOR' LOOP VARIABLE SAVE AREA FROM THE STACK
; *
; * 'PUSHA' STACKS THE 'FOR' LOOP VARIABLE SAVE AREA INTO THE STACK
;
MVUP:   CALL    COMP            ; *** MVUP ***  ; do COMPare HL and DE
        RET     Z               ; DE=HL, RETURN
        CALL    LDE             ; GET ONE BYTE [load from TeXT if necessary]
        PUSH    HL              ; SHOVEL REGS
        LD      H,B
        LD      L,C
        CALL    STHL            ; MOVE IT [interlaced into TeXT if necessary]
        POP     HL
        INC     DE              ; INCREASE BOTH POINTERS
        INC     BC
        JR      MVUP            ; UNTIL DONE

MVDOWN: LD      A,B             ; *** MVDOWN ***
        SUB     D               ; TEST IF DE = BC
        JP      NZ,MD1          ; NO, GO MOVE
        LD      A,C             ; MAYBE, OTHER BYTE
        SUB     E
        RET     Z               ; YES, RETURN
MD1:    DEC     DE              ; ELSE MOVE A BYTE
        DEC     HL              ; BUT FIRST DECREASE
        CALL    LDE             ; BOTH PTRS AND THEN [load from TeXT if necessary]
        CALL    STHL            ; DO IT [interlaced into TeXT if necessary]
        JR      MVDOWN          ; LOOP BACK

POPA:   POP     BC              ; BC = RETURN ADDR.
        POP     HL              ; RESTORE LOPVAR, BUT
        LD      (LOPVAR),HL     ; =0 MEANS NO MORE
        LD      A,H
        OR      L
        JP      Z,PPAX          ; YEP, GO RETURN
        POP     HL              ; NO, RESTORE OTHERS
        LD      (LOPINC),HL
        POP     HL
        LD      (LOPLMT),HL
        POP     HL
        LD      (LOPLN),HL
        POP     HL
        LD      (LOPPT),HL
PPAX:   PUSH    BC              ; BC = RETURN ADDR.
        RET

PUSHA:  LD      HL,STKLMT       ; *** PUSHA ***
        CALL    CHGSGN          ; do CHanGe SiGN of HL
        POP     BC              ; BC = RETURN ADDR.
        ADD     HL,SP           ; IS STACK NEAR THE TOP?
        JP      NC,QSORRY       ; YES - SORRY FOR THAT
        LD      HL,(LOPVAR)     ; ELSE SAVE LOOP VAR.S
        LD      A,H             ; BUT IF LOPVAR IS 0
        OR      L               ; THAT WILL BE ALL
        JP      Z,PUAX
        LD      HL,(LOPPT)      ; ELSE MORE TO SAVE
        PUSH    HL
        LD      HL,(LOPLN)
        PUSH    HL
        LD      HL,(LOPLMT)
        PUSH    HL
        LD      HL,(LOPINC)
        PUSH    HL
        LD      HL,(LOPVAR)
PUAX:   PUSH    HL
        PUSH    BC              ; BC = RETURN ADDR.
        RET

; * *** PRTSTG *** QTSTG *** PRTNUM *** AND PRTLN ***
; *
; * 'PRTSTG' PRINTS A STRING POINTED AT BY DE.  IT STOPS
; * PRINTING AND RETURNS TO CALLER WHEN EITHER A CR IS
; * PRINTED OR WHEN THE NEXT BYTE IS ZERO.  REG. A AND B
; * ARE CHANGED.  REG. DE POINTS TO WHAT FOLLOWS THE CR
; * OR TO THE ZERO
; *
; * 'QTSTG' LOOKS FOR SINGLE QUOTE, OR DOUBLE QUOTE.  IF
; * EITHER IT PRINTS THE STRING UNTIL MATCHING UNQUOTE
; * AND RETURNS 2 BYTES LATE.
; *
; * 'PRTNUM' PRINTS THE NUMBER HL.  LEADING BLANKS ARE ADDED
; * IF NEEDED TO PAD THE NUMBER OF SPACES TO THE NUMBER IN C.
; * HOWEVER, IF THE NUMBER OF DIGITS IS LARGER THAN THE # IN C,
; * ALL DIGITS ARE PRINTED ANYWAY.  NEGATIVE SIGN IS ALSO
; * PRINTED AND INCLUDED IN COUNT.  POSITIVE SIGN IS NOT.
; *
; * 'PRTLN' FINDS A SAVED LINE, PRINTS THE LINE # AND A SPACE.
;
PRTSTG: SUB     A               ; *** PRTSTG ***
PTS1:   LD      B,A
PTS2:   CALL    LDE             ; GET A CHARACTER [load from TeXT if necessary]
        INC     DE              ; BUMP POINTER
        CP      B               ; SAME AS OLD A
        RET     Z               ; YES, RETURN
        RST     RSTOUT          ; ELSE PRINT IT  ;* Output Char. in A
        CP      CR              ; WAS IT A CR?
        JR      NZ,PTS2         ; NO - NEXT
        RET                     ; YES-RETURN

QTSTG:  TSTCC   $22,QTS2       ;* Char. to check; Jump bias if no match
        LD      A,$22           ; IF DOUBLE QUOTE-PRINT IT
QTS1:   CALL    PTS1            ; PRINT UNTIL ANOTHER
        CP      CR              ; WAS LAST ONE A CR?
        POP     HL              ; RETURN ADDRESS
        JP      Z,RUNX1         ; WAS CR, END OF THIS
        INC     HL              ; SKIP 2 BYTES, THEN RET
        INC     HL
        JP      (HL)

QTS2:   TSTCC   $27,QTS3       ;* Char. to check; Jump bias if no match
        LD      A,$27           ; OR IF SINGLE
        JR      QTS1            ; LIKEWIZE

QTS3:   RET

PRTCHS: LD      A,E
        CP      B
        RET     Z
        CALL    LDE             ; LD A,(DE) [from TeXT if necessary]
        RST     RSTOUT         ;* Output Char. in A
        INC     DE
        JR      PRTCHS

; *** PRTNUM ***
;
PRTNUM: LD      B,$00           ; B=SIGN
        CALL    CHKSGN          ; CHECK SIGN
        JP      P,PTN1          ; NO SIGN
        LD      B,'-'           ; B=SIGN
        DEC     C               ; '-' TAKES SPACE
PTN1:   PUSH    DE
        LD      DE,$000A
        PUSH    DE
        DEC     C
        PUSH    BC
PTN2:   CALL    DIVIDE          ; DIV HL BY 10
        LD      A,B             ; RESULT 0
        OR      C
        JP      Z,PTN3          ; YES, WE GOT ALL
        EX      (SP),HL         ; NO SAVE REMAINDER
        DEC     L               ; AND COUNT SPACE
        PUSH    HL              ; HL IS OLD BC
        LD      H,B             ; MOVE RESULT TO BC
        LD      L,C
        JR      PTN2            ; AND DIV BY 10

PTN3:   POP     BC              ; WE GOT ALL DIGITS IN
PTN4:   DEC     C               ; THE STACK
        LD      A,C             ; IF SPACE COUNT NEG
        OR      A
        JP      M,PTN5          ; NO LEADING BLANKS
        LD      A,' '
        RST     RSTOUT          ; SPACE OUTCH ;* Output Space
        JR      PTN4            ; MORE?

PTN5:   LD      A,B             ; PRINT SIGN
        OR      A
        CALL    NZ,OUTC         ; MAYBE - OR NULL
        LD      E,L             ; LAST REMAINDER IN E
PTN6:   LD      A,E             ; CHECK DIGIT IN E
        CP      $0A             ; 10 IS FLAG FOR NO MORE
        POP     DE
        RET     Z               ; IF SO RETURN
        ADD     A,'0'
        RST     RSTOUT          ; AND PRINT THE DIGIT  ;* Output Char. in A
        JR      PTN6            ; GO BACK FOR MORE

PRTLN:  CALL    LDE             ; *** PRTLN*** [load from TeXT if necessary]
        LD      L,A             ; LOW ORDER LINE #
        INC     DE
        CALL    LDE             ; HIGH ORDER [load from TeXT if necessary]
        LD      H,A
        INC     DE
        LD      C,$04           ; PRINT 4 DIGIT [minimum] LINE #
        CALL    PRTNUM          ; do PRinT NUMber in HL
        LD      A,' '           ; FOLLOWED BY BLANK
        RST     RSTOUT         ;* Output Char. in A
        RET

; Tables for some COMMANDS, FUNCTIONS, and RELATIVE OPERATIONS
TAB2:   ITEM    'TV',PUTCD      ; DIRECT-STATEMENT
        ITEM    'MU',PUTMU
        ITEM    '&',PUTIO
        ITEM    'CALL',DOCALL
        ITEM    '.',REM
        ITEM    '$',DOLLAR      ; for Calculator routine
        DB      ':'
        TOKEN   $68,TVLIST      ; on :LIST
        DB      ':'
        TOKEN   $74,TOUTPU      ; on :PRINT
        DB      ':'
        TOKEN   $73,TINPUT      ; on :INPUT
        DB      ':'
if NORML ; ### conditional assembly ### {else routine deleted for TESTC}
        TOKEN   $6A,TLOAD       ; on :RUN
        DB      ':'             ; # - #
endif ; ##### end conditional #########
        TOKEN   $70,TCLOSE      ; on :RETURN
        DB      '*'
        TOKEN   $74,POUTPU      ; on *PRINT
        ITEM    'STOP',STOP
        DEFF    ENDCHK          ; [or DEFLT ?? ab just uses FINISH ??]
;* End list 1
;
;*       FUNCTIONS
;
TAB3:   TOKEN   $76,RND         ; Input FUNCTIONS
        ITEM    'KN',GETPOT
        ITEM    'TR',GETTRG
        ITEM    'JX',GETJX
        ITEM    'JY',GETJY
        ITEM    'KP',GETKB
        ITEM    'PX',PIXFUN
        ITEM    '&',IOFUN
        ITEM    'ABS',ABS
        ITEM    'SZ',SIZE
        DEFF    NOTF
;* End list 2

TAB6:   ITEM    '>=',XPR1       ; RELATION OPS
        ITEM    '#',XPR2
        ITEM    '>',XPR3
        ITEM    '=',XPR5
        ITEM    '<=',XPR4
        ITEM    '<',XPR6
        DEFF    XPR7
RANEND  EQU     $
;* End list 3

if TESTC ; ### conditional assembly ### {do new LINE EDITOR [if Key = EDKEY]}
GLED:   LD      A,(EDFLG)       ; {read Line EDit FLaG byte from $4E5B}
        AND     A               ; # + #
        JR      Z,GLEDA                 ; (+$14) if past first byte read
        LD      DE,BUFFER       ; {point at Line Input BUFFER start [$4ED4]}
        CALL    TSTNUM          ; {do $2A22 to see if it has a number}
        CALL    FNDLN           ; {do $2983 to see if that line exists}
        LD      A,'?'           ; {preset $3F for none-such line}
        RET     NZ
        INC     DE              ; {point at second byte of line number}
        CALL    GLEDB           ; {do writeNEXTintoMNMX}
        XOR     A
        LD      (EDFLG),A       ; {write 0 to $4E5B for first byte done}
GLEDA:  LD      DE,(EDPTR)      ; {read BUFFER address from $4E5C}
        CALL    LDE             ; {do $2FD0 to read from TXT}
; {writeNEXTintoMNMX: ??}
GLEDB:  INC     DE              ; # + #
        LD      (EDPTR),DE      ; {save next BUFFER address to $4E5C}
        RET                     ; # + #
endif ; ##### end conditional #########

; more routines here
;
;* Output A and input into BUFFER
GETLN:  LD      DE,BUFFER       ; *** GET a LiNe ***
if NORML ; ### conditional assembly ###
GL1:    RST     RSTOUT          ; PROMPT OR ECHO  ;* Output Char. in A
GL2:    PUSH    BC              ; # = #
        PUSH    DE              ; # 1 #
        PUSH    HL              ; # 2 #
else ; TESTC ####### conditional ###### else {add new line and flip PUSHes}...
        LD      (EDFLG),A       ; # + # {save non-zero EDit FLaG to $4E5B}
GL1:    RST     RSTOUT          ; PROMPT OR ECHO  ;* Output Char. in A
GL2:    PUSH    BC              ; # = #
        PUSH    HL              ; # 2 #
        PUSH    DE              ; # 1 #
endif ; ##### end conditional #########
; PLACE UP CURSOR BLOCK
        LD      C,$AA
        CALL    CURSE           ; do Draw CURSor
; RETURN CHAR FROM NEXT LINE #
GL2A:   LD      HL,NLLNCT
        LD      A,(HL)          ; SENSE FLAG
        AND     A
        JR      Z,GL2C
        DEC     (HL)
; FIRST TIME THRU?
        CP      $05
        JR      NZ,GL2B         ; JUMP IF NOT
; GET PREVIOUS LINE # AND BUMP IT
        LD      HL,(OLDLN)
        LD      DE,$000A
        ADD     HL,DE
        RES     7,H             ; ALLOW NEG
        LD      (NLLNLN),HL     ; MOVE TO WORKING RAM CELL
; COMPUTE DIVISION SUBTRACTOR
GL2B:   SYSSUK  INDEXW         ;* Get $2F0F+(A*2)
        DW      TBLDIV - 2     ;* to DE

        LD      HL,(NLLNLN)
        LD      B,$00
GL2E:   AND     A
        SBC     HL,DE
        JP      M,GL2F
        INC     B
        JR      GL2E

GL2F:   ADD     HL,DE
        LD      (NLLNLN),HL
        LD      HL,NLLNZS
        LD      A,B
        AND     A
        JR      NZ,GL2G
        LD      A,(HL)
        AND     A
        JR      Z,GL2A          ; YES - JUMP BACK
        XOR     A
GL2G:   ADD     A,'0'           ; MAKE ASCII
        LD      (HL),A          ; SET NONZERO FLAG
        JR      GL2D

; NOTHIN FANCY
GL2C:   CALL    CHKIO           ; GET NORMAL CHARACTER from keyboard
if NORML ; ### conditional assembly ###
GL2D:   POP     HL              ; # 1 #
        POP     DE              ; # 2 #
else ; TESTC ####### conditional ###### else {do EDIT [on Word+Pause or Word+Space]}
        POP     DE              ; # + #
        LD      (DE),A          ; {write Key into Line Input BUFFER as next token}
        PUSH    DE              ; # + #
        CP      EDKEY             ; {if Key = EDit KEY [new $66]}
        CALL    Z,GLED          ; {then do new Graphic Line EDitor}
GL2D:   POP     DE              ; # 2 # ... {and flip PUSHes}
        POP     HL              ; # 1 #
endif ; ##### end conditional #########
        POP     BC
        LD      (DE),A          ; STUFF CHAR AS DELIMITER
        CP      RUBOUT
        JR      NZ,GL4         ;* Jp if not ERASE
        LD      A,E
        CP      BUFFER & $00FF
        JR      Z,GL2          ;* Jp if at beginning
        DEC     DE
        LD      A,(DE)
        CP      $68             ; TOKEN TO RUB OUT?
        JR      NC,TOKIN
        CALL    PNOTE           ; do Play NOTE tone for key in A
        LD      A,RUBOUT
        JR      GL1

TOKIN:  PUSH    DE
        CALL    TOKEPT          ; do TOKEn PoinTer returned in HL
TOKER:  LD      A,(HL)
        PUSH    HL
        AND     $7F
        CALL    PNOTE           ; do Play NOTE tone for key in A
        LD      A,RUBOUT
        CALL    VDM             ; do Virtual Display Monitor output
        POP     HL
        LD      A,(HL)
        INC     HL
        RLCA
        JR      NC,TOKER
TOKEQ:  LD      A,RUBOUT        ; [label not needed]
        RST     RSTOUT          ; ECHO ONE RUBOUT CHAR  ;* Output Char. in A
        POP     DE
GL3:    JP      GL2

GL4:    CP      CR
        JP      Z,GL5
        LD      A,E
        CP      BUFEND & $00FF
        JR      Z,GL3
        LD      A,(DE)
        INC     DE
        JP      GL1

GL5:    INC     DE
        INC     DE
        LD      A,$FF
        LD      (DE),A
        DEC     DE
CRLF:   LD      A,CR            ; Carriage Return (and Line Feed)

; SUBROUTINE TO OUTPUT A CHARACTER [to ??] [?? how is this different from OUTCH ??]
;
;*       OUTC    (RST $18)
;
OUTC:   PUSH    HL
        PUSH    DE
        PUSH    BC
        PUSH    AF
        LD      D,A            ;* Save the character
        LD      A,(CHMODE)
        CP      $06
        JR      Z,OUTX1        ;* Jp if not *PRINT
        AND     $02
        JR      Z,OUTX2        ;* Jp if not :PRINT
OUT1:   LD      C,D
        RLC     C
OUT2:   IN      A,(SW2)         ; $12 for 300 Baud Interface ??
        AND     $02
        JR      Z,OUT2         ;* Wait for clock high [on down ??]
        LD      B,$0A          ;* Do 10 bits
OUT3:   LD      A,$C0
OUT4:   DEC     A
        JR      NZ,OUT4        ;* Give clock some time
        DEC     B              ;* Count output bits
        JR      Z,OUTX2
        IN      A,(SW2)
        LD      E,A
OUT5:   IN      A,(SW2)
        XOR     E
        AND     $02
        JR      Z,OUT5
        LD      A,E
        XOR     C
        AND     $02
        JR      Z,OUT6
        IN      A,(SW2)
OUT6:   SET     1,C
        RRC     C
        JR      OUT3

OUTX1:  LD      A,D            ;* *PRINT process
        CP      $68
        JR      C,OUT1         ;* Jp if not word
OUTX2:  LD      A,D
        CALL    VDM             ; do Virtual Display Monitor output
        POP     AF
        POP     BC
        POP     DE
        POP     HL
        RET

; SUBROUTINE TO SIMULATE A CHARACTER DISPLAY IN THE ARCADE
; FRAME BUFFER.  THE SIMULATED VDM [Virtual Display Monitor]
; HAS DIMENSIONS 26 CHARS BY 11 LINES.  THE CHARACTER GRAPHICS
; ARE 5 X 7 IN A 6 X 8 FRAME.  ALTERNATE FONT IS USED TO GET THIS.
; THE 64 UPPER CASE ASCII CHARACTERS ARE DISPLAYED BY THIS
; HANDLER.  THE ASCII CONTROL CHARACTERS CARRIAGE RETURN AND
; RUBOUT ARE ALSO PROCESSED BY THIS HANDLER.  CR CAUSES
; THE DISPLAY TO GO TO THE NEXT LINE OF THE DISPLAY, WITH
; SCROLL UP IF NECESSARY.  RUBOUT CAUSES THE CURSOR TO MOVE
; BACKWARDS ONE CHARACTER POSITION.
; CHARACTER TO DISPLAY IS IN A.  THE ALTERNATE REGISTER SET
; IS USED.
;
OUTCH:  LD      L,A
        LD      A,(CHMODE)
        CP      $06
        LD      A,L
        JR      Z,OUTC
; SOME FUNNY GUYS ENTER HERE
VDM:    CP      CR
        JR      Z,VDMOCR
        CP      RUBOUT          ; TRANSLATE TRASH TO ?
        JR      Z,VDM1
        JR      C,FILT1
        CP      $78
        JR      C,FILT2
FILT1:  LD      A,'?'
FILT2:  CP      $68             ; TOKEN TO PRINT?
        JR      NC,TOKEP        ; JUMP IF SO
; PLAY NOTE FOR THIS CHAR
        CALL    PNOTE           ; do Play NOTE tone for key in A
; NON NEW LINE CHAR - UNWRITE OLD CURSOR
VDM1:   CALL    UCURSE          ; do Undraw CURSor
        CALL    LDVDMC          ; do LoaD VDM Coordinates
        CP      RUBOUT          ; WAS THAT RUBOUT?
        JR      NZ,VDM3         ; JUMP IF NOT
; RUBOUT ENTERED - SO RUB OUT
        LD      A,L             ; GET X
        AND     A               ; IS X =0?
        JR      Z,VDM2          ; YES - JUMP
        SUB     $06             ; NO - BACKUP X
        LD      L,A
        JR      VDMDN1          ; AND JOIN STORE BACK

VDM2:   LD      L,$96
        LD      A,H
        SUB     $08
        LD      H,A
        JR      VDMDN1

; NEW LINE CHAR - DID WE JUST WRAP AROUND
VDMOCR: LD      A,(VDMNLF)      ; CHECK OLD GLORY
        AND     A
        JR      NZ,VDMDON       ; YES - SKIP DIDDLING
        CALL    UCURSE          ; NO - UNWRITE CURSOR
        CALL    NEWLIN          ; GO TO NEXT LINE
        JR      VDMDON          ; AND QUIT

; NORMAL CHARACTER ENTERED - DISPLAY IT
VDM3:   LD      D,H             ; COORDINATES TO DE
        LD      E,L
        OR      $80             ; ALT FONT THE CHAR
        LD      C,011000B       ; OR WRITE THE CHAR
        LD      IX,ALTFON       ; USING ALTERNATE CHAR FONT
        SYSTEM  CHRDIS          ; IT  ;* Display Character

        LD      A,L             ; ADVANCE X POINTER  ;* Skip a space
        ADD     A,6
        LD      L,A
        CP      $9C             ; END OF LINE?
        JR      NZ,VDMDN1       ; NO - JUMP
        CALL    NEWLIN          ; YES - NEW 1 LINE
        LD      A,$01           ; AND SET NEW LINE FORCED FLAG
        JR      VDMDN2

VDMDN1: CALL    STVDMC          ; do STore VDM Coordinates
VDMDON: XOR     A               ; CLEAR NEW LINE FORCED FLAG
VDMDN2: LD      (VDMNLF),A
        RET

; ROUTINE TO DISPLAY A TOKEN IN FULL FORM
;
TOKEP:  CALL    TOKEPT          ; do TOKEn PoinTer returned in HL
TOKEP1: LD      A,(HL)
        AND     $7F
        PUSH    HL
        CALL    OUTCH           ; do OUTput CHaracter in A
        POP     HL
        LD      A,(HL)
        INC     HL
        RLCA
        JR      NC,TOKEP1
        LD      A,' '           ; PUT SPACE AFTER TOKEN
        JP      OUTCH           ; AND GO HOME via OUTput CHaracter

; SUBROUTINE TO UNWRITE THE CURSOR
;
UCURSE: LD      C,$00
        JR      CURSE           ; do Draw CURSor in BC

; SUBROUTINE TO DISPLAY NEW LINE
;
NEWLIN: CALL    LDVDMC          ; do LoaD VDM Coordinates
; IS SCROLL UP NEEDED?
        LD      L,$00
        LD      A,H
        CP      $50
        JR      NZ,NEWL1        ; JUMP IF NOT NEEDED
; SCROLL UP IS NEEDED
        CALL    STVDMC          ; do STore VDM Coordinates
; NORMAL [interlaced] SCROLL MODE
        LD      HL,NORMEM + $58*BYTEPL
SCRL9:  LD      A,(HL)
        AND     01010101B      ;* Save screen bits
        LD      (HL),A         ;* Make them good
        INC     HL             ;* Move them up
        LD      A,L
        CP      $20
        JR      NZ,SCRL9
        LD      B,$04
SCRLP:  PUSH    BC
        LD      HL,NORMEM
        LD      DE,NORMEM + $50
        LD      BC,$980E
SCRUP:  LD      A,(DE)
        XOR     (HL)
        AND     10101010B
        XOR     (HL)
        LD      (HL),A
        INC     HL
        INC     DE
        DJNZ    SCRUP
        DEC     C
        JR      NZ,SCRUP
        POP     BC
        DJNZ    SCRLP
        RET

NEWL1:  ADD     A,$08
        LD      H,A
        CALL    STVDMC          ; do STore VDM Coordinates
        RET

; SUBROUTINE TO PAINT CURSOR
; C = DATA TO PAINT 00 OR AA
;
CURSE:  PUSH    AF             ;* Get CY/CX to HL
        CALL    LDVDMC          ; do LoaD VDM Coordinates
        EX      DE,HL
        XOR     A
        SYSTEM  RELAB1         ;* Subroutine 58

        OUT     (MAGIC),A
        EX      DE,HL
        LD      A,C
        LD      BC,$0806
        CALL    BOXPUT          ; do draw a BOX PUT on screen
        POP     AF
        RET

if NOKEY ; ### conditional assembly ### {to shut off KEYpad for DEMO}
CHKIO:          ; {DON'T read a character from keyboard or cassette tape}
SENWAI: JP      RUN            ; [to L254A to Begin Execution ??]
else ; KEYBD ####### conditional ###### else ...
CHKIO:          ; Read a character from keyboard or cassette tape
SENWAI: LD      A,(CHMODE)     ;* I/O flag
endif ; ##### end conditional #########
        DEC     A
        JR      NZ,XCHKIO      ;* Not 1 = KBD input
        CALL    KEYSCN         ;* 1 = TAP input, chk for abort
        JP      NZ,RINIT       ;* Abort, start over  ; Re-INITialize
        LD      HL,(TAPINS)    ;* Get tape input buffer pointer
        LD      A,H            ;* Get extract pointer
        CP      L
        JR      Z,SENWAI       ;* No data yet
        LD      L,A
        LD      H,TAPBUF >> 8  ; $4Exx
        LD      C,(HL)         ;* Get tape data
        CALL    RAMPIT          ; do Increment Tape Buffer pointer
        LD      (TAPEXT),A     ;* Update extract pointer
        LD      A,C            ;* Get byte
        RET

; Old KEYBOARD HANDLER
; No SHIFT KEY ROLLOVER
;
XCHKIO: CALL    KEYSCN          ; MAKE SURE PREVIOUS KEY RELEASE  ;* Get keyboard data
        JR      NZ,XCHKIO      ;* Wait till no key change
; AWAIT DEBOUNCE TIMER COUNTDOWN
        LD      HL,KEYTMR
        LD      (HL),$06        ; SET IT  ;* Set key release timer
LOOPER: LD      A,(HL)
        AND     A
        JR      NZ,LOOPER      ;* Wait for timer to expire
; SAVE BACKGROUND COLOR
        LD      A,(DEVCL0)     ;* Get BC
        PUSH    AF
; ASSUME FIRST LEVEL KEYCODE
        LD      HL,FIRSTL
GETK1:  PUSH    HL              ; SAVE TABLE PTR
; SCAN ONLY FOR SHIFT KEYS
        LD      HL,KTBL4
        LD      DE,$FFEB        ; (-21) ** SIZE OF LOOKUP TABLE  ;* 20 keys+color
        LD      BC,$0414
GETK2:  IN      A,(C)           ; INPUT FROM PORT  ;* Get shift key
        AND     $20             ; SHIFT KEY DOWN?
        JR      NZ,GETK3        ; JUMP IF YEP  ;* Got one
        ADD     HL,DE           ; ELSE TO NEXT TABLE  ;* Back up to previous table
        INC     C               ; AND PORT  ;* Next port
        DJNZ    GETK2          ;* Do all 4 ports
; NO SHIFT KEY IS DOWN - USE WHATEVER WE HAD BEFORE
        POP     HL             ;* Get current no-shift address
        JR      GETK5

; A SHIFT KEY IS DOWN - SAME OLD STORY?
GETK3:  POP     DE              ; DISCARD OLD BELIEFS  ;* Clear stack
        LD      A,(DEVCL0)      ; SET NEW COLOR  ;* Get BC
        CP      (HL)
        JR      Z,GETK4        ;* Jp if same as desired
        LD      A,(HL)         ;* Get desired BC
        LD      (DEVCL0),A     ;* Save it
        CALL    CLICK           ; do short Click
GETK4:  INC     HL              ; SKIP COLOR BYTE  ;* Point to keys
; NOW SCAN FOR ANY 'NORMAL' KEY DEPRESSION
GETK5:  CALL    KEYSCN         ;* Get input
;* Not there, allow different shift key
        JR      Z,GETK1         ; JUMP IF NO KEY DOWN
; WE GOT ONE - CONVERT TO ASCII
        DEC     A               ; BY TABLE LOOKUP  ;* Back to keys 0-23
        LD      C,A
        LD      B,$00
        ADD     HL,BC          ;* Point to conversion
        POP     AF              ; RESTORE COLOR  ;* Get original BC
        LD      (DEVCL0),A     ;* Reset it
        LD      A,(HL)          ; GET CODE  ;* Get key conversion
        AND     A               ; A HLT PERCHANCE?
        JR      Z,INIJMP        ; YEP - RESET  ;* Restart if no code
        CP      $01             ; AN ERROR?
        JP      Z,CHKIO         ; YEP - GO DOIT AGAIN  ;* Meaningless key
; GOOD KEY...
        PUSH    AF             ;* Save key code
        CP      NLLN
        JR      NC,CHKI02      ;* Jp if word
        SYSSUK  INDEXB          ; HL + A [not loaded!] to HL
        DW      DICKY + 7       ; Offset past DICKS MUSIC SYSTEM NOTE LOOKUP TABLE

        INC     A
        JR      NZ,CHKI02
        CALL    CLICK           ; do Click if $FF (GO,ERASE,+,-,0,x,divide)
CHKI02: POP     AF             ;* Regain converted key
        CP      NLLN           ;* Was it GO+10 ?
        RET     NZ
        LD      HL,$0005       ;* Yes
        LD      (NLLNCT),HL     ; SET FLAG AND ZERO SUPPRESS
        LD      A,$0D           ; PASS BACK CR AS FIRST CHAR  ;* Return a CR
        RET

; Old CLICK ROUTINE
;
CLICK:  LD      A,(NEWTMR)     ;* Wait for current note to finish
        AND     A
        JR      NZ,CLICK        ; Finish Previous Note
        LD      A,G0            ; $FD or 253 (not "GO")
        LD      (MUZTON),A
        LD      A,(DEVTEM)     ;* Get note time
        AND     A
        RET     Z               ; Silence if Tempo = 0
        LD      A,$01          ;* 1 beat delay
        LD      (NEWTMR),A      ; Short Click
        RET


; SUBROUTINE TO CHECK FOR HLT KEY WHILE PGM RUNNING
;* Check for PAUSE or ABORT
;
if NOKEY ; ### conditional assembly ### {for BASIC DEMO}
WHATSU: RET                     ; # - # {short-circuit routine}
else ; KEYBD ####### conditional ###### else...
WHATSU: PUSH    BC              ; # + # do it
endif ; ##### end conditional #########
        PUSH    DE
        CALL    KEYSCN          ; GET KEY CODE  ;* Get calculator input
        SUB     $02             ; FREEZE?  ;* Was it PAUSE?
        JR      Z,FRZKEY       ;* Yes
        DEC     A
        JR      Z,INIJMP       ;* Jp if HALT
        JR      FRZGBK          ; ELSE GO BACK TO CALLER  ;* Else leave

;* PAUSE: wait for another key
FRZKEY: CALL    KEYSCN          ; SCAN FOR NONZERO KEY TO REL
        JR      Z,FRZKEY
        CP      $03             ; HLT NAILED?  ;* Was it another HALT
INIJMP: JP      Z,INIT         ;* Yes, restart
FRZGBK: POP     DE
        POP     BC
        RET

; SUBROUTINE TO SCAN TINY BASIC KEYBOARD
;* KEYPAD INPUT (all but shift)
;
KEYSCN: LD      BC,$0414        ; B = CNT, C = PORT #
        LD      DE,KEYTRK       ; DE = KEYBOARD MEMORY
        XOR     A
        SYSTEM  RANGED         ;* Random number

KYSCN1: IN      A,(C)           ; LOOK AT COLUMN  ;* Raw key number
        AND     $1F             ; ISOLATE THE RELEVANT
        JR      NZ,KYSCN2       ; JUMP IF BITS HIGH  ;* Got one
        INC     C               ; BUMP PORT #  ;* Next port
        DJNZ    KYSCN1         ;* Do all input ports
        XOR     A               ; SET ZERO STATUS
        LD      (DE),A          ; NOTHIN - SAY ZIP  ;* Set last key = 0
        RET                    ;* and leave

; DEPRESSION FOUND - JUMP UP AND DOWN
KYSCN2: DEC     B
        LD      C,$00           ; COME UP WITH BIT #
KYSCN4: RRCA                    ; SHIFT BIT OVER
        JR      C,KYSCN3        ; JUMP IF THE ONE
        INC     C               ; ELSE COUNT UP
        JR      KYSCN4          ; AND TRY AGAIN

; FOUND BIT - ASSEMBLE KEYCODE
KYSCN3: LD      A,C             ; BIT # TO A
        RLCA                    ; * 4
        RLCA
        OR      B               ; COMBINE WITH COL #
        INC     A              ;* Keys 1-24
        LD      B,A
        LD      A,(DE)
        XOR     B
        RET     Z               ; QUIT IF THE SAME  ;* Leave if same as last time
        LD      A,B            ;* Save new value
        LD      (DE),A          ; ELSE UPDATE TRACKER
        RET                    ;*  and leave

; SUBROUTINE TO PLAY A NOTE
;* NOTE OUTPUT
;
PNOTE:  PUSH    HL
        PUSH    DE
        PUSH    AF
        LD      H,A
; WAIT FOR PREVIOUS PARAMETERS TO BE EATEN
PRWAIT: LD      A,(NEWTMR)
        AND     A
        JR      NZ,PRWAIT       ; LOOP
        LD      A,H
        CP      $63
        JR      Z,PNOTDV        ; Down an octave on Divide sign
        CP      $62
        JR      Z,PNOTML        ; Up an octave on Multiply sign
        CP      '+'
        JR      Z,PNOTPL        ; Sharp next note +1 through +7
        CP      '-'
        JR      Z,PNOTMN        ; Flat next note -1 through -7
        CP      '0'
        JR      Z,PNOTZ         ; to Play Note Zero
        LD      HL,DICKY + 7    ; Offset past DICKS MUSIC SYSTEM NOTE LOOKUP TABLE
; Tone STORe routine by A from table at HL  ;* HL+A to HL
TSTOR:  SYSTEM  INDEXB          ; INDEX BYTE (SYSTEM SUBROUTINE)

        INC     A
        JR      Z,PNOTCL        ; on GO  ;* -1 is no sound
        INC     A
        JR      Z,ANSW          ; Play Notes 1 thru 7  ;* -2 is number key
        DEC     A
        DEC     A
        LD      (MUZTON),A     ;* Save next note
        LD      A,(DEVTEM)
        LD      (NEWTMR),A
PNOTCL: XOR     A               ; Clear SHARPF  ;* Set for normal notes
PSHARP: LD      (SHARPF),A
LINKB:  POP     AF
        POP     DE
        POP     HL
        RET

PNOTDV: LD      A,OA1
MSTOR:  LD      (MUZMO),A       ; Master oscillator STORe  ;* Set master sound divider
        JR      LINKB

PNOTML: LD      A,OA3
        JR      MSTOR

PNOTPL: LD      A,$01          ;* Set for sharps
        DB      $11             ; does a LD DE,$023E  ;* Skips 2 bytes
PNOTMN: DB      $3E             ; does a LD A,$02  ;* Set for flats
        DB      $02
        JR      PSHARP          ; save as SHARPF

PNOTZ:  LD      HL,MUZTMR       ; Play NOTe Zero routine
        LD      A,(DEVTEM)
        DI
        ADD     A,(HL)          ; add NT to MUZTMR  ;* Increment note timer by one NT
        LD      (HL),A
        EI
        JR      LINKB           ; LINK Back

ANSW:   LD      A,(SHARPF)      ; *** for Dick AiNSWorth ***
        SYSSUK  INDEXW          ; INDEX WORD (SYSTEM SUBROUTINE)
        DW      DICKY

        EX      DE,HL
        POP     AF
        PUSH    AF
        SUB     '1'            ;* Set for proper increment
        JR      TSTOR

; SUBROUTINE TO POINT AT A TOKEN
;
TOKEPT: LD      HL,TOKTXT       ; POINT AT TEXT LIST
        SUB     $68
JOKEP1: RET     Z               ; QUIT IF POINTING AT EM
JOKEP2: BIT     7,(HL)          ; MOVE PAST NEXT WORD
        INC     HL
        JR      Z,JOKEP2
        DEC     A
        JR      JOKEP1          ; LOOP BACK AND CHECK

; DICKS MUSIC SYSTEM NOTE LOOKUP TABLE
DICKY:  DW      NORMAL         ;* Normal note table

        DW      SHARPS         ;* Sharp note table

        DW      FLATS          ;* Flat note table
;
;* FLAT 1-8 TABLE, also NULL and ASCII VALUE NOTE TABLE 0 to 5
FLATS:  DB      $64,$59,$4F,$4A,$42,$3B,$34
;
;* NORMAL 1-8 TABLE, also SCII VALUE NOTE TABLE 6 to 12 & 13 (Carriage return)
NORMAL: DB      $5E,$54,$4A,$46,$3E,$37,$31
        DB      $FF             ; DICKY + 7 + CR

TBLDIV: DW      $0001           ; 1  ;* also ASCII VALUE NOTES 14, 15
        DW      $000A           ; 10  ;* also ... 16, 17
        DW      $0064           ; 100  ;* also 18, 19
        DW      $03E8           ; 1000  ;* also 20, 21
        DW      $2710           ; 10000  ;* also 22, 23

;* SHARP 1-8 TABLE, also ASCII VALUE NOTE TABLE 24 to 30
SHARPS: DB      $59,$4F,$46,$42,$3B,$34,$2E

; Each Letter has its own Note offset DICKY + 7 + ASCII
        DB      $FF             ; ASCII 31 (Erase aka RUBOUT)
; 16 SYMBOLS from Space ! " # $ % & ' ( ) * + , - . /
        DB      $00,$E1,$D4,$C8,$BD,$B2,$A8,$9F
        DB      $96,$8D,$85,$FF,$77,$FF,$6A,$64
; Flags for NUMBERS 0 through 7
        DB      $FF,$FE,$FE,$FE,$FE,$FE,$FE,$FE
; NUMBERS 8 and 9 plus 6 SYMBOLS from  : ; < = > ?
        DB      $2E,$2C,$29,$27,$25,$22,$20,$1F
; AT sign and LETTERS A through Z plus  [ \ ] Up Left
        DB      $1D,$1B,$1A,$18,$17,$15,$14,$13
        DB      $12,$11,$10,$0F,$0E,$0D,$0B,$0A
        DB      $09,$08,$07,$06,$05,$04,$03,$02
        DB      $01,$64,$5E,$59,$54,$4F,$4A,$46
; Ending with Down and Right then Multiply and Divide
        DB      $42,$3E,$FF,$FF

; TABLE OF FIST LEVEL KEYCODES
;* CHARACTER TABLE, NO SHIFT KEYS
FIRSTL:
        DB      CR              ; Go
        DB      DEADKEY         ; Pause
        DB      $00             ; Halt
        DB      $63             ; Divide
        DB      '7'
        DB      '8'
        DB      '9'
        DB      $62             ; Multiply
        DB      '4'
        DB      '5'
        DB      '6'
        DB      '-'
        DB      '1'
        DB      '2'
        DB      '3'
        DB      '+'
        DB      ' '
        DB      '0'
        DB      RUBOUT
        DB      '='

; FIRST SHIFT KEY
;* PORT 17 SHIFT KEY (GREEN BACKGROUND)
KTBL1:
        DB      $A7             ; FIRST SHIFT KEY COLOR = Green
        DB      CR              ; (green + Go)
        DB      DEADKEY         ; (Pause)
        DB      $00             ; (green + Halt)
        DB      DEADKEY         ; (divide)
        DB      'A'
        DB      'D'
        DB      'G'
        DB      'J'
        DB      'M'
        DB      'P'
        DB      'S'
        DB      'V'
        DB      'Y'
        DB      $5F             ; Left Arrow
        DB      $5E             ; Up Arrow
        DB      '&'
        DB      '$'
        DB      '<'
        DB      '('
        DB      '#'

; SECOND SHIFT KEY
;* PORT 16 SHIFT KEY (RED BACKGROUND)
KTBL2:
        DB      $5F             ; SECOND SHIFT KEY COLOR = Red
        DB      CR              ; (red + Go)
        DB      $2F             ; Slash
        DB      $00             ; (red + Halt)
        DB      $5B             ; Left Bracket
        DB      'B'
        DB      'E'
        DB      'H'
        DB      'K'
        DB      'N'
        DB      'Q'
        DB      'T'
        DB      'W'
        DB      'Z'
        DB      $27             ; Apostrophe
        DB      '.'
        DB      '@'
        DB      ','
        DB      $22             ; Quotes
        DB      ';'
        DB      '%'

; TABLE THE THIRD
;* PORT 15 SHIFT KEY (BLUE BACKGROUND)
KTBL3:
        DB      $0F             ; THIRD SHIFT KEY COLOR = Blue
        DB      CR              ; (blue + Go)
        DB      $5C             ; Backslash
        DB      $00             ; (blue + Halt)
        DB      $5D             ; Right Bracket
        DB      'C'
        DB      'F'
        DB      'I'
        DB      'L'
        DB      'O'
        DB      'R'
        DB      'U'
        DB      'X'
        DB      '!'
        DB      $61              ; Right Arrow
        DB      $60              ; Down Arrow
        DB      '*'
        DB      '?'
        DB      '>'
        DB      ')'
        DB      ':'

; TOKEN KEY
;* PORT 14 SHIFT KEY (WORDS)
KTBL4:
        DB      $77             ; WORDS KEY COLOR = Gold
        DB      NLLN            ; GO+10
if NORML ; ### conditional assembly ###
        DB      DEADKEY         ; # 0 # (Pause)
else ; TESTC ####### conditional ###### else...
        DB      EDKEY           ; # 1 # {word + Pause} [new $66]
endif ; ##### end conditional #########
        DB      $6A             ; RUN token
        DB      $68             ; LIST token
        DB      $72             ; FOR token
        DB      $77             ; TO token
        DB      $75             ; STEP token
        DB      $6B             ; NEXT token
        DB      $6F             ; GOSUB token
        DB      $70             ; RETURN token
        DB      $76             ; RND token
        DB      $6D             ; IF token
        DB      $69             ; CLEAR token
        DB      $6C             ; LINE token
        DB      $71             ; BOX token
        DB      $6E             ; GOTO token
if NORML ; ### conditional assembly ###
        DB      DEADKEY         ; # 0 # {Space}
else ; TESTC ####### conditional ###### else...
        DB      EDKEY           ; # 1 # {word + Space} [$66]
endif ; ##### end conditional #########
        DB      $73             ; INPUT token
        DB      DEADKEY         ; (BackSpace)
        DB      $74             ; PRINT token

;                    More Routines here

; SUBROUTINE TO LD   A,(DE) FROM SCREEN TEXT MEMORY IF NECESSARY
;
;* EXTRACT BYTE (DE) FROM SCRATCHPAD
;*                   OR
;* EXTRACT BYTE (DE*2) FROM HIDDEN SCREEN AREA
;
LDE:    EX      AF,AF'
        BIT     7,D
        JR      Z,LDE1         ;* Jp if normal scratchpad
        PUSH    DE
        EX      DE,HL
        ADD     HL,HL          ;* Double the phoney number
        LD      A,(HL)         ;* First get bits 7,5,3,1
        RLCA
        INC     HL
        XOR     (HL)
        AND     10101010B
        XOR     (HL)           ;* Then bits 6,4,2,0
        LD      H,A
        EX      AF,AF'
        LD      A,H            ;* Byte value to A
        EX      DE,HL
        POP     DE             ;* Don't mess up his pointer
        RET

LDE1:   EX      AF,AF'         ;* Extract normal data
        LD      A,(DE)
        RET

; STORE a byte INTO memory pointed to by HL Routines
;
;* DEPOSIT BYTE AT (HL) INTO SCRATCHPAD
;*                 OR
;* DEPOSIT BYTE AT (HL*2) INTO HIDDEN SCREEN AREA
;
STHL:   PUSH    HL
        PUSH    AF
        BIT     7,H
        JR      Z,STHL1        ;* Jp if normal deposit
        ADD     HL,HL          ;* Double his phoney number
        RRCA                   ;* Make bits 7,5,3,1 as
        XOR     (HL)           ;*  6,4,2,0 and get screen
        AND     01010101B      ;* Save screen bits
        XOR     (HL)           ;*  and restore mine
        LD      (HL),A         ;* Then place them away
        INC     HL
        POP     AF
        PUSH    AF             ;* Now bits 6,4,2,0
        XOR     (HL)           ;* With screen bits
        AND     01010101B
        XOR     (HL)           ;* Combined with mine
; SUBROUTINE TO STORE a byte using LD     (HL),A
STHL1:  LD      (HL),A         ;* For the screen area
        POP     AF
        POP     HL
        RET

if NORML ; ### conditional assembly ###
; Filler Byte to match original ROM image
        DB      $FF            ;* SPARE CELL
endif ; ##### end conditional #########

; END OF BALLY BASIC INTERPRETER

if INROM ; ### conditional assembly ### {BASIC program data}
; L3000:
        DB      $01,$00,$2E,$0D,$02,$00,$2E,$0D
        DB      $03,$00,$2E,$0D,$04,$00,$2E,$42
        DB      $41,$4C,$4C,$59,$20,$42,$41,$53
        DB      $49,$43,$20,$52,$4F,$4D,$20,$44
        DB      $45,$4D,$4F,$0D,$05,$00,$2E,$49
        DB      $50,$49,$0D,$0A,$00,$6E,$39,$30
        DB      $0D,$1E,$00,$72,$41,$3D,$31,$77
        DB      $35,$30,$30,$3B,$6B,$41,$3B,$69
        DB      $3B,$46,$43,$3D,$76,$28,$33,$31
        DB      $29,$62,$38,$2D,$31,$3B,$42,$43
        DB      $3D,$38,$0D,$1F,$00,$72,$4D,$3D
        DB      $31,$77,$32,$35,$30,$3B,$6B,$4D
        DB      $3B,$70,$0D,$20,$00,$72,$41,$3D
        DB      $31,$77,$39,$39,$39,$3B,$6B,$41
        DB      $3B,$46,$43,$3D,$46,$43,$2B,$38
        DB      $30,$3B,$70,$0D,$5A,$00,$42,$43
        DB      $3D,$43,$3D,$30,$3B,$4E,$54,$3D
        DB      $33,$3B,$69,$3B,$72,$41,$3D,$31
        DB      $77,$32,$35,$3B,$52,$3D,$58,$3B
        DB      $53,$3D,$59,$0D,$5F,$00,$58,$3D
        DB      $76,$28,$38,$30,$29,$2D,$31,$3B
        DB      $59,$3D,$76,$28,$34,$34,$29,$2D
        DB      $31,$0D,$64,$00,$6D,$58,$62,$58
        DB      $63,$31,$38,$30,$30,$2B,$59,$62
        DB      $59,$63,$35,$30,$3C,$31,$6E,$39
        DB      $35,$0D,$6E,$00,$46,$43,$3D,$76
        DB      $28,$33,$32,$29,$62,$38,$2D,$31
        DB      $3B,$4D,$55,$3D,$46,$43,$0D,$78
        DB      $00,$6F,$31,$34,$30,$35,$30,$0D
        DB      $8C,$00,$6B,$41,$3B,$43,$59,$3D
        DB      $30,$3B,$43,$58,$3D,$2D,$33,$30
        DB      $3B,$74,$22,$49,$4E,$54,$52,$4F
        DB      $44,$55,$43,$49,$4E,$47,$0D,$A0
        DB      $00,$6F,$33,$32,$3B,$43,$59,$3D
        DB      $30,$3B,$43,$58,$3D,$2D,$34,$38
        DB      $3B,$74,$22,$2A,$2A,$20,$42,$41
        DB      $4C,$4C,$59,$20,$42,$41,$53,$49
        DB      $43,$20,$2A,$2A,$0D,$C8,$00,$6F
        DB      $33,$30,$3B,$74,$3B,$74,$3B,$74
        DB      $3B,$43,$58,$3D,$2D,$32,$34,$3B
        DB      $74,$22,$72,$59,$4F,$55,$52,$0D
        DB      $D2,$00,$74,$3B,$43,$58,$3D,$2D
        DB      $31,$35,$3B,$74,$22,$42,$41,$4C
        DB      $4C,$59,$0D,$D7,$00,$74,$0D,$DC
        DB      $00,$74,$3B,$43,$58,$3D,$2D,$34
        DB      $32,$3B,$74,$22,$43,$4F,$4D,$50
        DB      $55,$54,$45,$52,$20,$53,$59,$53
        DB      $54,$45,$4D,$0D,$F0,$00,$6F,$33
        DB      $30,$3B,$74,$3B,$74,$3B,$74,$3B
        DB      $43,$58,$3D,$2D,$31,$32,$3B,$74
        DB      $22,$57,$49,$54,$48,$0D,$FA,$00
        DB      $74,$3B,$43,$58,$3D,$2D,$33,$30
        DB      $3B,$74,$22,$42,$41,$4C,$4C,$59
        DB      $20,$42,$41,$53,$49,$43,$0D,$04
        DB      $01,$74,$3B,$43,$58,$3D,$2D,$31
        DB      $35,$3B,$74,$22,$59,$4F,$55,$20
        DB      $43,$41,$4E,$2E,$2E,$2E,$0D,$90
        DB      $01,$6F,$33,$30,$3B,$74,$3B,$43
        DB      $58,$3D,$2D,$36,$30,$3B,$74,$22
        DB      $43,$52,$45,$41,$54,$45,$20,$59
        DB      $4F,$55,$52,$20,$4F,$57,$4E,$20
        DB      $47,$41,$4D,$45,$53,$0D,$9A,$01
        DB      $6F,$32,$30,$30,$30,$2B,$28,$76
        DB      $28,$32,$29,$2D,$31,$29,$62,$35
        DB      $30,$30,$0D,$C2,$01,$6F,$33,$30
        DB      $3B,$74,$3B,$43,$58,$3D,$2D,$34
        DB      $38,$3B,$74,$22,$57,$52,$49,$54
        DB      $45,$20,$4F,$4E,$20,$59,$4F,$55
        DB      $52,$20,$54,$56,$0D,$C3,$01,$74
        DB      $3B,$74,$3B,$74,$3B,$74,$3B,$74
        DB      $3B,$74,$3B,$74,$0D,$C4,$01,$74
        DB      $3B,$74,$3B,$74,$3B,$74,$22,$20
        DB      $20,$20,$20,$45,$44,$4E,$41,$3A
        DB      $0D,$C6,$01,$74,$22,$20,$20,$20
        DB      $20,$20,$20,$49,$27,$4D,$20,$4C
        DB      $45,$41,$56,$49,$4E,$47,$20,$2D
        DB      $20,$43,$41,$4E,$27,$54,$20,$0D
        DB      $C7,$01,$74,$22,$20,$20,$20,$20
        DB      $20,$50,$4C,$41,$59,$20,$53,$45
        DB      $43,$4F,$4E,$44,$20,$46,$49,$44
        DB      $44,$4C,$45,$0D,$C8,$01,$74,$22
        DB      $20,$20,$20,$20,$20,$54,$4F,$20
        DB      $59,$4F,$55,$52,$20,$43,$4F,$4D
        DB      $50,$55,$54,$45,$52,$0D,$C9,$01
        DB      $74,$3B,$74,$22,$20,$20,$20,$20
        DB      $20,$20,$20,$20,$20,$20,$20,$47
        DB      $45,$4F,$52,$47,$45,$0D,$CA,$01
        DB      $74,$3B,$74,$3B,$74,$3B,$74,$22
        DB      $20,$20,$20,$20,$45,$44,$4E,$41
        DB      $3A,$0D,$CB,$01,$74,$22,$20,$20
        DB      $20,$20,$20,$20,$49,$20,$54,$48
        DB      $4F,$55,$47,$48,$54,$20,$48,$45
        DB      $27,$44,$20,$0D,$CC,$01,$74,$22
        DB      $20,$20,$20,$20,$20,$4E,$45,$56
        DB      $45,$52,$20,$47,$4F,$2E,$2E,$2E
        DB      $20,$46,$49,$4E,$41,$4C,$4C,$59
        DB      $0D,$CD,$01,$74,$22,$20,$20,$20
        DB      $20,$20,$57,$45,$20,$41,$52,$45
        DB      $20,$41,$4C,$4F,$4E,$45,$20,$21
        DB      $21,$0D,$CE,$01,$74,$3B,$74,$22
        DB      $20,$20,$20,$20,$20,$20,$20,$20
        DB      $20,$20,$59,$4F,$55,$52,$20,$43
        DB      $4F,$4D,$50,$55,$54,$45,$52,$0D
        DB      $D4,$01,$6F,$33,$30,$0D,$F4,$01
        DB      $74,$3B,$43,$58,$3D,$2D,$36,$30
        DB      $3B,$74,$22,$4D,$41,$4B,$45,$20
        DB      $59,$4F,$55,$52,$20,$4F,$57,$4E
        DB      $20,$4D,$55,$53,$49,$43,$0D,$FE
        DB      $01,$6F,$38,$30,$30,$30,$3B,$4E
        DB      $54,$3D,$33,$3B,$6F,$33,$30,$0D
        DB      $26,$02,$74,$3B,$43,$58,$3D,$2D
        DB      $36,$30,$3B,$74,$22,$44,$49,$53
        DB      $50,$4C,$41,$59,$20,$49,$4E,$46
        DB      $4F,$52,$4D,$41,$54,$49,$4F,$4E
        DB      $0D,$30,$02,$6F,$31,$31,$30,$30
        DB      $30,$3B,$6F,$33,$30,$0D,$58,$02
        DB      $74,$3B,$43,$58,$3D,$2D,$33,$36
        DB      $3B,$74,$22,$44,$52,$41,$57,$20
        DB      $50,$49,$43,$54,$55,$52,$45,$53
        DB      $0D,$62,$02,$6F,$33,$31,$3B,$69
        DB      $3B,$6F,$31,$34,$30,$30,$30,$3B
        DB      $6F,$33,$30,$0D,$20,$03,$74,$3B
        DB      $74,$3B,$43,$58,$3D,$2D,$36,$30
        DB      $3B,$74,$22,$57,$49,$54,$48,$20
        DB      $45,$41,$53,$59,$20,$49,$4E,$53
        DB      $54,$52,$55,$43,$54,$49,$4F,$4E
        DB      $53,$0D,$2A,$03,$74,$3B,$43,$58
        DB      $3D,$2D,$33,$36,$3B,$74,$22,$59
        DB      $4F,$55,$20,$43,$41,$4E,$20,$57
        DB      $52,$49,$54,$45,$0D,$34,$03,$74
        DB      $3B,$43,$58,$3D,$2D,$35,$34,$3B
        DB      $74,$22,$41,$20,$43,$4F,$4D,$50
        DB      $55,$54,$45,$52,$20,$50,$52,$4F
        DB      $47,$52,$41,$4D,$0D,$3E,$03,$74
        DB      $3B,$43,$58,$3D,$2D,$33,$36,$3B
        DB      $74,$22,$49,$4E,$20,$4D,$49,$4E
        DB      $55,$54,$45,$53,$21,$21,$0D,$48
        DB      $03,$6F,$33,$30,$3B,$74,$3B,$74
        DB      $0D,$52,$03,$74,$3B,$43,$58,$3D
        DB      $2D,$35,$34,$3B,$74,$22,$2A,$2A
        DB      $20,$42,$41,$4C,$4C,$59,$20,$42
        DB      $41,$53,$49,$43,$20,$2A,$2A,$0D
        DB      $5C,$03,$74,$3B,$74,$3B,$43,$58
        DB      $3D,$2D,$34,$32,$3B,$74,$22,$4D
        DB      $41,$4B,$45,$53,$20,$49,$54,$20
        DB      $45,$41,$53,$59,$0D,$66,$03,$6F
        DB      $33,$32,$3B,$74,$3B,$43,$58,$3D
        DB      $2D,$32,$31,$3B,$74,$22,$41,$4E
        DB      $44,$20,$46,$55,$4E,$0D,$84,$03
        DB      $6F,$33,$30,$3B,$43,$59,$3D,$2D
        DB      $33,$39,$3B,$74,$22,$20,$20,$20
        DB      $74,$27,$42,$4F,$58,$27,$22,$3B
        DB      $43,$58,$3D,$2D,$36,$3B,$43,$59
        DB      $3D,$30,$3B,$74,$22,$71,$22,$3B
        DB      $6F,$33,$32,$0D,$B6,$03,$43,$59
        DB      $3D,$2D,$33,$39,$3B,$74,$22,$20
        DB      $20,$20,$71,$30,$2C,$30,$2C,$36
        DB      $30,$2C,$35,$30,$2C,$33,$22,$3B
        DB      $71,$30,$2C,$30,$2C,$36,$31,$2C
        DB      $34,$39,$2C,$33,$3B,$6F,$33,$32
        DB      $0D,$C0,$03,$43,$59,$3D,$2D,$33
        DB      $39,$3B,$74,$22,$20,$20,$20,$71
        DB      $34,$30,$2C,$30,$2C,$31,$33,$2C
        DB      $34,$39,$2C,$33,$22,$3B,$71,$34
        DB      $30,$2C,$30,$2C,$31,$33,$2C,$34
        DB      $39,$2C,$33,$3B,$6F,$33,$32,$0D
        DB      $C5,$03,$43,$59,$3D,$2D,$33,$39
        DB      $3B,$74,$22,$20,$20,$20,$71,$2D
        DB      $34,$30,$2C,$30,$2C,$31,$33,$2C
        DB      $34,$39,$2C,$33,$22,$3B,$71,$2D
        DB      $34,$30,$2C,$30,$2C,$31,$33,$2C
        DB      $34,$39,$2C,$33,$3B,$6F,$33,$32
        DB      $0D,$CA,$03,$43,$59,$3D,$2D,$33
        DB      $39,$3B,$74,$22,$20,$20,$20,$71
        DB      $34,$30,$2C,$32,$30,$2C,$35,$2C
        DB      $35,$2C,$33,$20,$20,$20,$22,$3B
        DB      $71,$34,$30,$2C,$32,$30,$2C,$35
        DB      $2C,$35,$2C,$33,$3B,$6F,$33,$32
        DB      $0D,$CF,$03,$43,$59,$3D,$2D,$33
        DB      $39,$3B,$74,$22,$20,$20,$20,$71
        DB      $34,$30,$2C,$31,$30,$2C,$35,$2C
        DB      $35,$2C,$33,$22,$3B,$71,$34,$30
        DB      $2C,$31,$30,$2C,$35,$2C,$35,$2C
        DB      $33,$3B,$6F,$33,$32,$0D,$D4,$03
        DB      $43,$59,$3D,$2D,$33,$39,$3B,$74
        DB      $22,$20,$20,$20,$71,$30,$2C,$30
        DB      $2C,$39,$39,$2C,$35,$39,$2C,$33
        DB      $22,$3B,$71,$30,$2C,$30,$2C,$39
        DB      $39,$2C,$35,$39,$2C,$33,$3B,$6F
        DB      $33,$32,$0D,$DE,$03,$43,$59,$3D
        DB      $2D,$33,$39,$3B,$74,$22,$20,$20
        DB      $20,$6C,$30,$2C,$33,$30,$2C,$33
        DB      $20,$20,$20,$20,$20,$20,$22,$3B
        DB      $6C,$30,$2C,$33,$30,$2C,$34,$3B
        DB      $6C,$32,$30,$2C,$34,$33,$2C,$33
        DB      $3B,$6F,$33,$32,$0D,$E0,$03,$43
        DB      $59,$3D,$2D,$33,$39,$3B,$74,$22
        DB      $20,$20,$20,$6C,$2D,$32,$30,$2C
        DB      $34,$33,$2C,$30,$20,$20,$20,$20
        DB      $22,$3B,$6C,$2D,$32,$30,$2C,$34
        DB      $33,$2C,$30,$3B,$6C,$30,$2C,$33
        DB      $30,$2C,$33,$3B,$6F,$33,$32,$0D
        DB      $E8,$03,$6C,$30,$2C,$30,$2C,$34
        DB      $3B,$71,$30,$2C,$30,$2C,$32,$30
        DB      $2C,$39,$2C,$32,$0D,$FC,$03,$71
        DB      $30,$2C,$30,$2C,$36,$31,$2C,$34
        DB      $39,$2C,$32,$0D,$06,$04,$43,$59
        DB      $3D,$2D,$33,$39,$3B,$74,$22,$20
        DB      $20,$20,$71,$30,$2C,$30,$2C,$76
        DB      $28,$58,$29,$2C,$76,$28,$59,$29
        DB      $22,$0D,$10,$04,$72,$41,$3D,$31
        DB      $77,$34,$30,$3B,$42,$3D,$76,$28
        DB      $32,$36,$29,$62,$32,$3B,$71,$30
        DB      $2C,$30,$2C,$42,$2C,$42,$2C,$33
        DB      $3B,$42,$43,$3D,$42,$43,$2B,$38
        DB      $3B,$6B,$41,$0D,$2E,$04,$72,$41
        DB      $3D,$31,$77,$35,$30,$3B,$58,$3D
        DB      $76,$28,$31,$36,$30,$29,$2B,$31
        DB      $3B,$59,$3D,$58,$63,$32,$0D,$38
        DB      $04,$4D,$55,$3D,$76,$28,$31,$30
        DB      $29,$3B,$42,$43,$3D,$76,$28,$32
        DB      $35,$35,$29,$3B,$46,$43,$3D,$42
        DB      $43,$2B,$34,$0D,$42,$04,$71,$30
        DB      $2C,$30,$2C,$58,$2C,$59,$2C,$33
        DB      $3B,$6B,$41,$0D,$56,$04,$42,$43
        DB      $3D,$30,$3B,$46,$43,$3D,$31,$31
        DB      $31,$3B,$69,$0D,$DC,$05,$74,$3B
        DB      $74,$3B,$43,$58,$3D,$2D,$31,$38
        DB      $3B,$74,$22,$41,$4E,$44,$2E,$2E
        DB      $2E,$0D,$E6,$05,$74,$3B,$43,$58
        DB      $3D,$2D,$34,$32,$3B,$74,$22,$59
        DB      $4F,$55,$20,$43,$41,$4E,$20,$43
        DB      $52,$45,$41,$54,$45,$0D,$F0,$05
        DB      $74,$3B,$43,$58,$3D,$2D,$33,$36
        DB      $3B,$74,$22,$41,$4E,$20,$41,$44
        DB      $56,$45,$4E,$54,$55,$52,$45,$0D
        DB      $40,$06,$74,$3B,$43,$58,$3D,$2D
        DB      $34,$36,$3B,$74,$22,$49,$4E,$20
        DB      $4F,$55,$54,$45,$52,$20,$53,$50
        DB      $41,$43,$45,$0D,$44,$06,$4E,$54
        DB      $3D,$30,$3B,$69,$0D,$45,$06,$26
        DB      $28,$31,$37,$29,$3D,$35,$30,$3B
        DB      $26,$28,$31,$38,$29,$3D,$32,$30
        DB      $3B,$26,$28,$32,$32,$29,$3D,$32
        DB      $35,$35,$3B,$6F,$32,$30,$30,$32
        DB      $30,$0D,$68,$06,$26,$28,$32,$32
        DB      $29,$3D,$30,$3B,$26,$28,$31,$36
        DB      $29,$3D,$30,$3B,$26,$28,$31,$37
        DB      $29,$3D,$30,$3B,$26,$28,$31,$38
        DB      $29,$3D,$30,$3B,$26,$28,$32,$33
        DB      $29,$3D,$30,$3B,$4E,$54,$3D,$33
        DB      $0D,$72,$06,$6F,$33,$32,$3B,$43
        DB      $59,$3D,$31,$36,$3B,$43,$58,$3D
        DB      $2D,$34,$32,$3B,$74,$22,$59,$4F
        DB      $55,$27,$52,$45,$20,$41,$20,$57
        DB      $49,$4E,$4E,$45,$52,$0D,$7C,$06
        DB      $74,$3B,$43,$58,$3D,$2D,$31,$32
        DB      $3B,$74,$22,$57,$49,$54,$48,$0D
        DB      $86,$06,$74,$3B,$43,$58,$3D,$2D
        DB      $34,$38,$3B,$74,$22,$2A,$2A,$20
        DB      $42,$41,$4C,$4C,$59,$20,$42,$41
        DB      $53,$49,$43,$20,$2A,$2A,$0D,$A4
        DB      $06,$6F,$33,$30,$3B,$74,$3B,$43
        DB      $58,$3D,$2D,$31,$38,$3B,$74,$22
        DB      $4E,$4F,$57,$2E,$2E,$2E,$0D,$AE
        DB      $06,$74,$3B,$43,$58,$3D,$2D,$34
        DB      $38,$3B,$74,$22,$43,$52,$45,$41
        DB      $54,$45,$20,$59,$4F,$55,$52,$20
        DB      $4F,$57,$4E,$0D,$B3,$06,$71,$32
        DB      $39,$2C,$31,$31,$2C,$31,$38,$2C
        DB      $31,$2C,$31,$0D,$B8,$06,$74,$3B
        DB      $43,$58,$3D,$2D,$34,$32,$3B,$74
        DB      $22,$41,$44,$56,$45,$4E,$54,$55
        DB      $52,$45,$53,$21,$2E,$2E,$2E,$0D
        DB      $D6,$06,$6F,$33,$30,$3B,$43,$58
        DB      $3D,$2D,$31,$32,$3B,$43,$59,$3D
        DB      $38,$3B,$74,$22,$57,$49,$54,$48
        DB      $0D,$E0,$06,$43,$58,$3D,$2D,$35
        DB      $34,$3B,$43,$59,$3D,$2D,$38,$3B
        DB      $74,$22,$2A,$2A,$20,$42,$41,$4C
        DB      $4C,$59,$20,$42,$41,$53,$49,$43
        DB      $20,$2A,$2A,$0D,$EA,$06,$4E,$54
        DB      $3D,$30,$0D,$08,$07,$4E,$54,$3D
        DB      $30,$3B,$6F,$33,$30,$3B,$43,$59
        DB      $3D,$2D,$34,$30,$3B,$43,$58,$3D
        DB      $2D,$39,$3B,$74,$22,$54,$48,$45
        DB      $0D,$0D,$07,$74,$3B,$74,$0D,$12
        DB      $07,$43,$58,$3D,$2D,$32,$37,$3B
        DB      $74,$22,$42,$45,$47,$49,$4E,$4E
        DB      $49,$4E,$47,$0D,$1C,$07,$4E,$54
        DB      $3D,$33,$0D,$6C,$07,$72,$41,$3D
        DB      $31,$77,$31,$30,$3B,$42,$43,$3D
        DB      $76,$28,$32,$35,$35,$29,$3B,$46
        DB      $43,$3D,$42,$43,$2B,$31,$32,$3B
        DB      $74,$3B,$6B,$41,$3B,$6E,$39,$30
        DB      $0D,$D0,$07,$41,$3D,$31,$30,$3B
        DB      $42,$3D,$32,$30,$3B,$43,$3D,$33
        DB      $30,$3B,$71,$30,$2C,$30,$2C,$36
        DB      $30,$2C,$31,$2C,$31,$3B,$71,$30
        DB      $2C,$2D,$42,$2C,$36,$30,$2C,$31
        DB      $2C,$31,$3B,$71,$2D,$41,$2C,$2D
        DB      $41,$2C,$31,$2C,$36,$30,$2C,$31
        DB      $3B,$71,$41,$2C,$2D,$41,$2C,$31
        DB      $2C,$36,$30,$2C,$31,$0D,$DA,$07
        DB      $6F,$33,$31,$3B,$43,$58,$3D,$2D
        DB      $42,$3B,$43,$59,$3D,$41,$3B,$74
        DB      $22,$58,$0D,$E4,$07,$6F,$33,$31
        DB      $3B,$43,$58,$3D,$2D,$42,$3B,$43
        DB      $59,$3D,$2D,$41,$3B,$74,$22,$4F
        DB      $0D,$EE,$07,$6F,$33,$31,$3B,$43
        DB      $58,$3D,$30,$3B,$43,$59,$3D,$2D
        DB      $43,$3B,$74,$22,$58,$0D,$F8,$07
        DB      $6F,$33,$31,$3B,$43,$58,$3D,$42
        DB      $3B,$43,$59,$3D,$2D,$41,$3B,$74
        DB      $22,$4F,$0D,$02,$08,$6F,$33,$31
        DB      $3B,$43,$58,$3D,$30,$3B,$43,$59
        DB      $3D,$2D,$41,$3B,$74,$22,$58,$0D
        DB      $0C,$08,$6F,$33,$31,$3B,$43,$58
        DB      $3D,$42,$3B,$43,$59,$3D,$2D,$43
        DB      $3B,$74,$22,$4F,$0D,$16,$08,$6F
        DB      $33,$31,$3B,$43,$58,$3D,$30,$3B
        DB      $43,$59,$3D,$41,$3B,$74,$22,$58
        DB      $0D,$20,$08,$6F,$33,$31,$3B,$71
        DB      $30,$2C,$2D,$41,$2C,$32,$30,$2C
        DB      $36,$30,$2C,$33,$0D,$60,$09,$72
        DB      $41,$3D,$31,$77,$31,$30,$30,$30
        DB      $3B,$6B,$41,$0D,$65,$09,$70,$0D
        DB      $C4,$09,$72,$41,$3D,$31,$77,$39
        DB      $3B,$71,$76,$28,$35,$31,$29,$2D
        DB      $32,$35,$2C,$2D,$76,$28,$33,$30
        DB      $29,$2C,$35,$2C,$35,$2C,$31,$3B
        DB      $6B,$41,$0D,$CE,$09,$72,$58,$3D
        DB      $2D,$32,$30,$77,$32,$30,$75,$39
        DB      $0D,$D3,$09,$4E,$54,$3D,$31,$0D
        DB      $D8,$09,$43,$59,$3D,$32,$33,$3B
        DB      $43,$58,$3D,$58,$2D,$39,$3B,$74
        DB      $22,$20,$20,$58,$0D,$E2,$09,$72
        DB      $59,$3D,$31,$38,$77,$2D,$33,$30
        DB      $75,$2D,$31,$0D,$E4,$09,$4D,$55
        DB      $3D,$36,$33,$2B,$59,$0D,$E7,$09
        DB      $6D,$50,$58,$28,$58,$2C,$59,$2D
        DB      $35,$29,$71,$58,$2C,$59,$2D,$35
        DB      $2C,$37,$2C,$38,$2C,$32,$3B,$4E
        DB      $54,$3D,$39,$3B,$4D,$55,$3D,$34
        DB      $32,$3B,$59,$3D,$2D,$33,$30,$0D
        DB      $EC,$09,$71,$58,$2C,$59,$2C,$33
        DB      $2C,$33,$2C,$31,$3B,$71,$58,$2C
        DB      $59,$2C,$33,$2C,$33,$2C,$32,$3B
        DB      $6B,$59,$0D,$00,$0A,$6B,$58,$3B
        DB      $4E,$54,$3D,$33,$0D,$0A,$0A,$70
        DB      $0D,$40,$1F,$6D,$76,$28,$33,$29
        DB      $3E,$31,$6E,$38,$32,$30,$30,$0D
        DB      $45,$1F,$4E,$54,$3D,$38,$0D,$47
        DB      $1F,$69,$0D,$4A,$1F,$74,$22,$35
        DB      $30,$33,$30,$35,$30,$30,$30,$35
        DB      $30,$33,$30,$35,$30,$30,$30,$36
        DB      $30,$35,$30,$34,$30,$33,$30,$32
        DB      $30,$33,$30,$34,$30,$33,$34,$35
        DB      $30,$31,$30,$31,$30,$31,$30,$31
        DB      $32,$33,$34,$35,$30,$30,$30,$35
        DB      $30,$32,$30,$32,$30,$34,$30,$33
        DB      $30,$32,$30,$31,$30,$30,$30,$22
        DB      $0D,$54,$1F,$4E,$54,$3D,$33,$0D
        DB      $5E,$1F,$70,$0D,$08,$20,$6D,$76
        DB      $28,$32,$29,$3D,$31,$6E,$38,$33
        DB      $30,$30,$0D,$12,$20,$4E,$54,$3D
        DB      $31,$30,$3B,$69,$3B,$6F,$38,$32
        DB      $35,$30,$3B,$74,$22,$35,$30,$30
        DB      $30,$33,$30,$33,$30,$30,$2B,$32
        DB      $33,$30,$2B,$34,$30,$30,$30,$2B
        DB      $32,$30,$63,$37,$30,$30,$30,$30
        DB      $30,$0D,$1C,$20,$6F,$38,$32,$35
        DB      $30,$3B,$74,$22,$35,$30,$30,$30
        DB      $2B,$34,$33,$30,$2B,$32,$30,$30
        DB      $2B,$31,$2B,$32,$30,$33,$30,$30
        DB      $30,$30,$30,$33,$30,$30,$30,$22
        DB      $3B,$70,$0D,$3A,$20,$74,$22,$62
        DB      $32,$30,$30,$30,$30,$30,$62,$32
        DB      $30,$30,$62,$31,$37,$30,$36,$30
        DB      $30,$30,$2B,$34,$30,$32,$30,$30
        DB      $33,$2B,$34,$22,$3B,$70,$0D,$6C
        DB      $20,$4E,$54,$3D,$31,$30,$0D,$76
        DB      $20,$69,$3B,$72,$41,$3D,$31,$77
        DB      $32,$3B,$74,$22,$20,$20,$31,$63
        DB      $36,$32,$30,$63,$36,$30,$30,$63
        DB      $37,$31,$63,$36,$32,$30,$63,$36
        DB      $30,$30,$63,$37,$31,$30,$34,$30
        DB      $33,$30,$32,$30,$31,$63,$36,$32
        DB      $30,$63,$36,$30,$30,$30,$22,$3B
        DB      $6B,$41,$3B,$70,$0D,$F8,$2A,$6C
        DB      $2D,$36,$30,$2C,$2D,$34,$30,$2C
        DB      $34,$3B,$42,$3D,$35,$30,$62,$76
        DB      $28,$32,$29,$0D,$FD,$2A,$72,$59
        DB      $3D,$2D,$34,$30,$77,$32,$30,$75
        DB      $31,$30,$3B,$71,$30,$2C,$59,$2C
        DB      $31,$32,$30,$2C,$31,$2C,$31,$3B
        DB      $6B,$59,$0D,$02,$2B,$72,$58,$3D
        DB      $2D,$36,$30,$77,$36,$30,$75,$31
        DB      $30,$3B,$6F,$31,$31,$30,$30,$30
        DB      $2B,$42,$3B,$6B,$58,$0D,$0C,$2B
        DB      $70,$0D,$2A,$2B,$6C,$58,$2C,$76
        DB      $28,$36,$30,$29,$2D,$34,$30,$2C
        DB      $31,$3B,$71,$58,$2C,$2D,$31,$30
        DB      $2C,$31,$2C,$36,$30,$2C,$31,$3B
        DB      $70,$0D,$5C,$2B,$72,$41,$3D,$2D
        DB      $33,$35,$77,$76,$28,$36,$30,$29
        DB      $2D,$33,$35,$75,$35,$3B,$71,$58
        DB      $2C,$41,$2C,$37,$2C,$35,$2C,$31
        DB      $3B,$6B,$41,$3B,$70,$0D,$B0,$36
        DB      $42,$43,$3D,$30,$3B,$46,$43,$3D
        DB      $76,$28,$33,$31,$29,$62,$38,$2D
        DB      $31,$3B,$6E,$31,$34,$30,$30,$30
        DB      $2B,$76,$28,$33,$29,$62,$31,$30
        DB      $0D,$BA,$36,$72,$41,$3D,$31,$77
        DB      $32,$35,$3B,$52,$3D,$30,$3B,$58
        DB      $3D,$76,$28,$34,$30,$29,$3B,$53
        DB      $3D,$76,$28,$34,$30,$29,$3B,$6F
        DB      $31,$34,$30,$35,$30,$3B,$6B,$41
        DB      $3B,$70,$0D,$C4,$36,$72,$41,$3D
        DB      $31,$77,$31,$35,$3B,$52,$3D,$30
        DB      $3B,$53,$3D,$30,$3B,$58,$3D,$76
        DB      $28,$34,$30,$29,$3B,$59,$3D,$76
        DB      $28,$34,$30,$29,$3B,$6F,$31,$34
        DB      $30,$35,$30,$3B,$6B,$41,$3B,$70
        DB      $0D,$CE,$36,$72,$41,$3D,$31,$77
        DB      $32,$35,$3B,$52,$3D,$59,$3B,$53
        DB      $3D,$58,$3B,$58,$3D,$76,$28,$34
        DB      $30,$29,$3B,$59,$3D,$76,$28,$34
        DB      $30,$29,$3B,$6F,$31,$34,$30,$35
        DB      $30,$3B,$6B,$41,$3B,$70,$0D,$E2
        DB      $36,$6C,$52,$2C,$53,$2C,$34,$3B
        DB      $6C,$58,$2C,$59,$2C,$31,$3B,$6C
        DB      $2D,$52,$2C,$2D,$53,$2C,$34,$3B
        DB      $6C,$2D,$58,$2C,$2D,$59,$2C,$31
        DB      $0D,$EC,$36,$6C,$2D,$52,$2C,$53
        DB      $2C,$34,$3B,$6C,$2D,$58,$2C,$59
        DB      $2C,$31,$3B,$6C,$52,$2C,$2D,$53
        DB      $2C,$34,$3B,$6C,$58,$2C,$2D,$59
        DB      $2C,$31,$3B,$70,$0D,$34,$4E,$72
        DB      $53,$3D,$31,$77,$32,$35,$3B,$71
        DB      $76,$28,$31,$36,$30,$29,$2D,$38
        DB      $30,$2C,$76,$28,$38,$36,$29,$2D
        DB      $34,$33,$2C,$31,$2C,$31,$2C,$31
        DB      $3B,$6B,$53,$0D,$48,$4E,$71,$30
        DB      $2C,$31,$35,$2C,$38,$31,$2C,$31
        DB      $35,$2C,$31,$3B,$71,$30,$2C,$31
        DB      $35,$2C,$32,$31,$2C,$32,$31,$2C
        DB      $31,$0D,$5C,$4E,$72,$58,$3D,$2D
        DB      $34,$30,$77,$34,$30,$3B,$71,$58
        DB      $2C,$31,$35,$2C,$31,$2C,$32,$2C
        DB      $32,$3B,$58,$3D,$58,$2D,$31,$2B
        DB      $28,$31,$38,$30,$30,$2D,$58,$62
        DB      $58,$29,$63,$32,$30,$30,$3B,$6B
        DB      $58,$0D,$7A,$4E,$58,$3D,$2D,$33
        DB      $30,$3B,$59,$3D,$2D,$34,$32,$3B
        DB      $4D,$3D,$30,$3B,$4E,$3D,$34,$0D
        DB      $7F,$4E,$6F,$32,$30,$33,$30,$30
        DB      $0D,$B6,$4E,$72,$43,$58,$3D,$2D
        DB      $32,$30,$77,$33,$35,$3B,$43,$59
        DB      $3D,$2D,$33,$30,$2B,$43,$58,$63
        DB      $32,$3B,$54,$56,$3D,$22,$58,$22
        DB      $3B,$43,$58,$3D,$43,$58,$2D,$36
        DB      $0D,$BB,$4E,$26,$28,$31,$36,$29
        DB      $3D,$76,$28,$32,$33,$29,$2B,$34
        DB      $30,$0D,$C0,$4E,$71,$43,$58,$2D
        DB      $31,$2C,$43,$59,$2C,$35,$2C,$35
        DB      $2C,$31,$3B,$71,$43,$58,$2C,$43
        DB      $59,$2C,$20,$39,$2C,$39,$2C,$32
        DB      $3B,$6B,$43,$58,$3B,$74,$22,$58
        DB      $22,$0D,$CA,$4E,$71,$33,$35,$2C
        DB      $2D,$31,$33,$2C,$33,$2C,$33,$2C
        DB      $31,$0D,$D4,$4E,$58,$3D,$35,$32
        DB      $3B,$59,$3D,$2D,$33,$30,$3B,$6F
        DB      $32,$30,$33,$30,$30,$0D,$DE,$4E
        DB      $58,$3D,$33,$35,$3B,$59,$3D,$2D
        DB      $35,$3B,$6F,$32,$30,$33,$30,$30
        DB      $0D,$E8,$4E,$58,$3D,$30,$3B,$59
        DB      $3D,$31,$35,$3B,$4D,$3D,$33,$32
        DB      $3B,$4E,$3D,$2D,$31,$30,$0D,$F2
        DB      $4E,$72,$41,$3D,$31,$77,$33,$3B
        DB      $6F,$32,$30,$33,$30,$30,$3B,$6B
        DB      $41,$0D,$FC,$4E,$72,$41,$3D,$32
        DB      $77,$35,$30,$75,$35,$0D,$06,$4F
        DB      $71,$41,$2C,$31,$35,$2C,$76,$28
        DB      $34,$30,$29,$2C,$76,$28,$31,$35
        DB      $29,$2C,$33,$0D,$10,$4F,$71,$2D
        DB      $41,$2C,$31,$35,$2C,$76,$28,$34
        DB      $30,$29,$2C,$76,$28,$31,$35,$29
        DB      $2C,$33,$0D,$14,$4F,$72,$42,$3D
        DB      $31,$77,$32,$30,$3B,$26,$28,$31
        DB      $36,$29,$3D,$42,$2B,$35,$30,$3B
        DB      $6B,$42,$0D,$15,$4F,$71,$30,$2C
        DB      $31,$35,$2C,$41,$62,$33,$2C,$41
        DB      $63,$32,$2B,$31,$2C,$32,$0D,$1A
        DB      $4F,$6B,$41,$3B,$42,$43,$3D,$30
        DB      $0D,$24,$4F,$72,$41,$3D,$31,$77
        DB      $32,$35,$3B,$71,$76,$20,$28,$31
        DB      $36,$30,$29,$2D,$38,$30,$2C,$76
        DB      $28,$33,$30,$29,$2C,$31,$2C,$31
        DB      $2C,$31,$3B,$6B,$41,$3B,$70,$0D
        DB      $4C,$4F,$6C,$4D,$2C,$4E,$2C,$34
        DB      $3B,$6C,$58,$2C,$59,$2C,$31,$3B
        DB      $6C,$4D,$2C,$4E,$2C,$34,$3B,$6C
        DB      $58,$2C,$59,$2C,$32,$0D,$50,$4F
        DB      $26,$28,$32,$31,$29,$3D,$32,$35
        DB      $35,$0D,$51,$4F,$72,$42,$3D,$32
        DB      $35,$35,$77,$30,$75,$2D,$33,$32
        DB      $3B,$26,$28,$32,$33,$29,$3D,$42
        DB      $3B,$6B,$42,$0D,$56,$4F,$26,$28
        DB      $32,$31,$29,$3D,$30,$3B,$26,$28
        DB      $32,$33,$29,$3D,$30,$3B,$70,$0D
        DB      $00,$FF,$00,$00,$00,$00,$00,$00

endif ; ##### end conditional ######### end BASIC program data

; {end BASICDEM.ASM listing}
        END


; {BASICDEM note: BASIC listing for reference only}

1 .
2 .
3 .
4 .BALLY BASIC ROM DEMO
5 .IPI
10 GOTO 90
30 FOR A=1TO 500;NEXT A;CLEAR ;FC=RND (31)8-1;BC=8
31 FOR M=1TO 250;NEXT M;RETURN
32 FOR A=1TO 999;NEXT A;FC=FC+80;RETURN
90 BC=C=0;NT=3;CLEAR ;FOR A=1TO 25;R=X;S=Y
95 X=RND (80)-1;Y=RND (44)-1
100 IF XX1800+YY50<1GOTO 95
110 FC=RND (32)8-1;MU=FC
120 GOSUB 14050
140 NEXT A;CY=0;CX=-30;PRINT "INTRODUCING
160 GOSUB 32;CY=0;CX=-48;PRINT "** BALLY BASIC **
200 GOSUB 30;PRINT ;PRINT ;PRINT ;CX=-24;PRINT "FOR YOUR
210 PRINT ;CX=-15;PRINT "BALLY
215 PRINT
220 PRINT ;CX=-42;PRINT "COMPUTER SYSTEM
240 GOSUB 30;PRINT ;PRINT ;PRINT ;CX=-12;PRINT "WITH
250 PRINT ;CX=-30;PRINT "BALLY BASIC
260 PRINT ;CX=-15;PRINT "YOU CAN...
400 GOSUB 30;PRINT ;CX=-60;PRINT "CREATE YOUR OWN GAMES
410 GOSUB 2000+(RND (2)-1)500
450 GOSUB 30;PRINT ;CX=-48;PRINT "WRITE ON YOUR TV
451 PRINT ;PRINT ;PRINT ;PRINT ;PRINT ;PRINT ;PRINT
452 PRINT ;PRINT ;PRINT ;PRINT "    EDNA:
454 PRINT "      I'M LEAVING - CAN'T
455 PRINT "     PLAY SECOND FIDDLE
456 PRINT "     TO YOUR COMPUTER
457 PRINT ;PRINT "           GEORGE
458 PRINT ;PRINT ;PRINT ;PRINT "    EDNA:
459 PRINT "      I THOUGHT HE'D
460 PRINT "     NEVER GO... FINALLY
461 PRINT "     WE ARE ALONE !!
462 PRINT ;PRINT "          YOUR COMPUTER
468 GOSUB 30
500 PRINT ;CX=-60;PRINT "MAKE YOUR OWN MUSIC
510 GOSUB 8000;NT=3;GOSUB 30
550 PRINT ;CX=-60;PRINT "DISPLAY INFORMATION
560 GOSUB 11000;GOSUB 30
600 PRINT ;CX=-36;PRINT "DRAW PICTURES
610 GOSUB 31;CLEAR ;GOSUB 14000;GOSUB 30
800 PRINT ;PRINT ;CX=-60;PRINT "WITH EASY INSTRUCTIONS
810 PRINT ;CX=-36;PRINT "YOU CAN WRITE
820 PRINT ;CX=-54;PRINT "A COMPUTER PROGRAM
830 PRINT ;CX=-36;PRINT "IN MINUTES!!
840 GOSUB 30;PRINT ;PRINT
850 PRINT ;CX=-54;PRINT "** BALLY BASIC **
860 PRINT ;PRINT ;CX=-42;PRINT "MAKES IT EASY
870 GOSUB 32;PRINT ;CX=-21;PRINT "AND FUN
900 GOSUB 30;CY=-39;PRINT "   PRINT 'BOX'";CX=-6;CY=0;PRINT "BOX ";GOSUB 32
950 CY=-39;PRINT "   BOX 0,0,60,50,3";BOX 0,0,61,49,3;GOSUB 32
960 CY=-39;PRINT "   BOX 40,0,13,49,3";BOX 40,0,13,49,3;GOSUB 32
965 CY=-39;PRINT "   BOX -40,0,13,49,3";BOX -40,0,13,49,3;GOSUB 32
970 CY=-39;PRINT "   BOX 40,20,5,5,3   ";BOX 40,20,5,5,3;GOSUB 32
975 CY=-39;PRINT "   BOX 40,10,5,5,3";BOX 40,10,5,5,3;GOSUB 32
980 CY=-39;PRINT "   BOX 0,0,99,59,3";BOX 0,0,99,59,3;GOSUB 32
990 CY=-39;PRINT "   LINE 0,30,3      ";LINE 0,30,4;LINE 20,43,3;GOSUB 32
992 CY=-39;PRINT "   LINE -20,43,0    ";LINE -20,43,0;LINE 0,30,3;GOSUB 32
1000 LINE 0,0,4;BOX 0,0,20,9,2
1020 BOX 0,0,61,49,2
1030 CY=-39;PRINT "   BOX 0,0,RND (X),RND (Y)"
1040 FOR A=1TO 40;B=RND (26)2;BOX 0,0,B,B,3;BC=BC+8;NEXT A
1070 FOR A=1TO 50;X=RND (160)+1;Y=X2
1080 MU=RND (10);BC=RND (255);FC=BC+4
1090 BOX 0,0,X,Y,3;NEXT A
1110 BC=0;FC=111;CLEAR
1500 PRINT ;PRINT ;CX=-18;PRINT "AND...
1510 PRINT ;CX=-42;PRINT "YOU CAN CREATE
1520 PRINT ;CX=-36;PRINT "AN ADVENTURE
1600 PRINT ;CX=-46;PRINT "IN OUTER SPACE
1604 NT=0;CLEAR
1605 &(17)=50;&(18)=20;&(22)=255;GOSUB 20020
1640 &(22)=0;&(16)=0;&(17)=0;&(18)=0;&(23)=0;NT=3
1650 GOSUB 32;CY=16;CX=-42;PRINT "YOU'RE A WINNER
1660 PRINT ;CX=-12;PRINT "WITH
1670 PRINT ;CX=-48;PRINT "** BALLY BASIC **
1700 GOSUB 30;PRINT ;CX=-18;PRINT "NOW...
1710 PRINT ;CX=-48;PRINT "CREATE YOUR OWN
1715 BOX 29,11,18,1,1
1720 PRINT ;CX=-42;PRINT "ADVENTURES!...
1750 GOSUB 30;CX=-12;CY=8;PRINT "WITH
1760 CX=-54;CY=-8;PRINT "** BALLY BASIC **
1770 NT=0
1800 NT=0;GOSUB 30;CY=-40;CX=-9;PRINT "THE
1805 PRINT ;PRINT
1810 CX=-27;PRINT "BEGINNING
1820 NT=3
1900 FOR A=1TO 10;BC=RND (255);FC=BC+12;PRINT ;NEXT A;GOTO 90
2000 A=10;B=20;C=30;BOX 0,0,60,1,1;BOX 0,-B,60,1,1;BOX -A,-A,1,60,1;BOX A,-A,1,60,1
2010 GOSUB 31;CX=-B;CY=A;PRINT "X
2020 GOSUB 31;CX=-B;CY=-A;PRINT "O
2030 GOSUB 31;CX=0;CY=-C;PRINT "X
2040 GOSUB 31;CX=B;CY=-A;PRINT "O
2050 GOSUB 31;CX=0;CY=-A;PRINT "X
2060 GOSUB 31;CX=B;CY=-C;PRINT "O
2070 GOSUB 31;CX=0;CY=A;PRINT "X
2080 GOSUB 31;BOX 0,-A,20,60,3
2400 FOR A=1TO 1000;NEXT A
2405 RETURN
2500 FOR A=1TO 9;BOX RND (51)-25,-RND (30),5,5,1;NEXT A
2510 FOR X=-20TO 20STEP 9
2515 NT=1
2520 CY=23;CX=X-9;PRINT "  X
2530 FOR Y=18TO -30STEP -1
2532 MU=63+Y
2535 IF PX(X,Y-5)BOX X,Y-5,7,8,2;NT=9;MU=42;Y=-30
2540 BOX X,Y,3,3,1;BOX X,Y,3,3,2;NEXT Y
2560 NEXT X;NT=3
2570 RETURN
8000 IF RND (3)>1GOTO 8200
8005 NT=8
8007 CLEAR
8010 PRINT "5030500050305000605040302030403450101010123450005020204030201000"
8020 NT=3
8030 RETURN
8200 IF RND (2)=1GOTO 8300
8210 NT=10;CLEAR ;GOSUB 8250;PRINT "500030300+230+4000+20700000
8220 GOSUB 8250;PRINT "5000+430+200+1+203000003000";RETURN
8250 PRINT "2000002001706000+402003+4";RETURN
8300 NT=10
8310 CLEAR ;FOR A=1TO 2;PRINT "  16206007162060071040302016206000";NEXT A;RETURN
11000 LINE -60,-40,4;B=50RND (2)
11005 FOR Y=-40TO 20STEP 10;BOX 0,Y,120,1,1;NEXT Y
11010 FOR X=-60TO 60STEP 10;GOSUB 11000+B;NEXT X
11020 RETURN
11050 LINE X,RND (60)-40,1;BOX X,-10,1,60,1;RETURN
11100 FOR A=-35TO RND (60)-35STEP 5;BOX X,A,7,5,1;NEXT A;RETURN
14000 BC=0;FC=RND (31)8-1;GOTO 14000+RND (3)10
14010 FOR A=1TO 25;R=0;X=RND (40);S=RND (40);GOSUB 14050;NEXT A;RETURN
14020 FOR A=1TO 15;R=0;S=0;X=RND (40);Y=RND (40);GOSUB 14050;NEXT A;RETURN
14030 FOR A=1TO 25;R=Y;S=X;X=RND (40);Y=RND (40);GOSUB 14050;NEXT A;RETURN
14050 LINE R,S,4;LINE X,Y,1;LINE -R,-S,4;LINE -X,-Y,1
14060 LINE -R,S,4;LINE -X,Y,1;LINE R,-S,4;LINE X,-Y,1;RETURN
20020 FOR S=1TO 25;BOX RND (160)-80,RND (86)-43,1,1,1;NEXT S
20040 BOX 0,15,81,15,1;BOX 0,15,21,21,1
20060 FOR X=-40TO 40;BOX X,15,1,2,2;X=X-1+(1800-XX)200;NEXT X
20090 X=-30;Y=-42;M=0;N=4
20095 GOSUB 20300
20150 FOR CX=-20TO 35;CY=-30+CX2;TV="X";CX=CX-6
20155 &(16)=RND (23)+40
20160 BOX CX-1,CY,5,5,1;BOX CX,CY, 9,9,2;NEXT CX;PRINT "X"
20170 BOX 35,-13,3,3,1
20180 X=52;Y=-30;GOSUB 20300
20190 X=35;Y=-5;GOSUB 20300
20200 X=0;Y=15;M=32;N=-10
20210 FOR A=1TO 3;GOSUB 20300;NEXT A
20220 FOR A=2TO 50STEP 5
20230 BOX A,15,RND (40),RND (15),3
20240 BOX -A,15,RND (40),RND (15),3
20244 FOR B=1TO 20;&(16)=B+50;NEXT B
20245 BOX 0,15,A3,A2+1,2
20250 NEXT A;BC=0
20260 FOR A=1TO 25;BOX RND  (160)-80,RND (30),1,1,1;NEXT A;RETURN
20300 LINE M,N,4;LINE X,Y,1;LINE M,N,4;LINE X,Y,2
20304 &(21)=255
20305 FOR B=255TO 0STEP -32;&(23)=B;NEXT B
20310 &(21)=0;&(23)=0;RETURN

; {end BASIC program ran for DEMO}

; {BASICDEM note: TXTUNF -256 marker and 6 NOPs to fill}
        DB      $00,$FF,$00,$00,$00,$00,$00,$00

; {end BASICDEM note}
